/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.common;

import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class KeyValues
implements Iterable<KeyValue> {
    private static final KeyValues EMPTY = new KeyValues(new KeyValue[0]);
    private final KeyValue[] keyValues;
    private int last;

    private KeyValues(KeyValue[] keyValueArray) {
        this.keyValues = keyValueArray;
        Arrays.sort(this.keyValues);
        this.dedup();
    }

    private void dedup() {
        int n2 = this.keyValues.length;
        if (n2 == 0 || n2 == 1) {
            this.last = n2;
            return;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            if (this.keyValues[i2].getKey().equals(this.keyValues[i2 + 1].getKey())) continue;
            this.keyValues[n3++] = this.keyValues[i2];
        }
        this.keyValues[n3++] = this.keyValues[n2 - 1];
        this.last = n3;
    }

    public KeyValues and(String string, String string2) {
        return this.and(KeyValue.of(string, string2));
    }

    public KeyValues and(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return this;
        }
        return this.and(KeyValues.of(stringArray));
    }

    public KeyValues and(KeyValue ... keyValueArray) {
        if (keyValueArray == null || keyValueArray.length == 0) {
            return this;
        }
        KeyValue[] keyValueArray2 = new KeyValue[this.last + keyValueArray.length];
        System.arraycopy(this.keyValues, 0, keyValueArray2, 0, this.last);
        System.arraycopy(keyValueArray, 0, keyValueArray2, this.last, keyValueArray.length);
        return new KeyValues(keyValueArray2);
    }

    public <E> KeyValues and(@Nullable Iterable<E> iterable, Function<E, String> function, Function<E, String> function2) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return this;
        }
        Function<Object, KeyValue> function3 = object -> KeyValue.of(object, function, function2);
        Iterable iterable2 = () -> StreamSupport.stream(iterable.spliterator(), false).map(function3).iterator();
        return this.and(iterable2);
    }

    public KeyValues and(@Nullable Iterable<? extends KeyValue> iterable) {
        if (iterable == null || iterable == EMPTY || !iterable.iterator().hasNext()) {
            return this;
        }
        if (this.keyValues.length == 0) {
            return KeyValues.of(iterable);
        }
        return this.and(KeyValues.of(iterable).keyValues);
    }

    @Override
    public Iterator<KeyValue> iterator() {
        return new ArrayIterator();
    }

    @Override
    public Spliterator<KeyValue> spliterator() {
        return Spliterators.spliterator(this.keyValues, 0, this.last, 1301);
    }

    public Stream<KeyValue> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.last; ++i2) {
            n2 = 31 * n2 + this.keyValues[i2].hashCode();
        }
        return n2;
    }

    public boolean equals(@Nullable Object object) {
        return this == object || object != null && this.getClass() == object.getClass() && this.keyValuesEqual((KeyValues)object);
    }

    private boolean keyValuesEqual(KeyValues keyValues) {
        if (this.keyValues == keyValues.keyValues) {
            return true;
        }
        if (this.last != keyValues.last) {
            return false;
        }
        for (int i2 = 0; i2 < this.last; ++i2) {
            if (this.keyValues[i2].equals(keyValues.keyValues[i2])) continue;
            return false;
        }
        return true;
    }

    public static KeyValues concat(@Nullable Iterable<? extends KeyValue> iterable, @Nullable Iterable<? extends KeyValue> iterable2) {
        return KeyValues.of(iterable).and(iterable2);
    }

    public static KeyValues concat(@Nullable Iterable<? extends KeyValue> iterable, String ... stringArray) {
        return KeyValues.of(iterable).and(stringArray);
    }

    public static <E> KeyValues of(@Nullable Iterable<E> iterable, Function<E, String> function, Function<E, String> function2) {
        return KeyValues.empty().and(iterable, function, function2);
    }

    public static KeyValues of(@Nullable Iterable<? extends KeyValue> iterable) {
        if (iterable == null || iterable == EMPTY || !iterable.iterator().hasNext()) {
            return KeyValues.empty();
        }
        if (iterable instanceof KeyValues) {
            return (KeyValues)iterable;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return new KeyValues(collection.toArray(new KeyValue[0]));
        }
        return new KeyValues((KeyValue[])StreamSupport.stream(iterable.spliterator(), false).toArray(KeyValue[]::new));
    }

    public static KeyValues of(String string, String string2) {
        return new KeyValues(new KeyValue[]{KeyValue.of(string, string2)});
    }

    public static KeyValues of(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return KeyValues.empty();
        }
        if (stringArray.length % 2 == 1) {
            throw new IllegalArgumentException("size must be even, it is a set of key=value pairs");
        }
        KeyValue[] keyValueArray = new KeyValue[stringArray.length / 2];
        for (int i2 = 0; i2 < stringArray.length; i2 += 2) {
            keyValueArray[i2 / 2] = KeyValue.of(stringArray[i2], stringArray[i2 + 1]);
        }
        return new KeyValues(keyValueArray);
    }

    public static KeyValues of(KeyValue ... keyValueArray) {
        return KeyValues.empty().and(keyValueArray);
    }

    public static KeyValues empty() {
        return EMPTY;
    }

    public String toString() {
        return this.stream().map((Function<KeyValue, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/contrastsecurity/thirdparty/io/micrometer/common/KeyValue;)Ljava/lang/String;)()).collect(Collectors.joining(",", "[", "]"));
    }

    private class ArrayIterator
    implements Iterator<KeyValue> {
        private int currentIndex = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < KeyValues.this.last;
        }

        @Override
        public KeyValue next() {
            return KeyValues.this.keyValues[this.currentIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove items from key values");
        }
    }
}

