/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging;

import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLogLevel;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class WarnThenDebugLogger {
    private final InternalLogger logger;
    private final AtomicBoolean warnLogged = new AtomicBoolean();

    public WarnThenDebugLogger(Class<?> clazz) {
        this.logger = InternalLoggerFactory.getInstance(clazz);
    }

    public void log(String string, Throwable throwable) {
        if (this.warnLogged.compareAndSet(false, true)) {
            this.log(InternalLogLevel.WARN, this.getWarnMessage(string), throwable);
        } else {
            this.log(InternalLogLevel.DEBUG, string, throwable);
        }
    }

    private String getWarnMessage(String string) {
        return string + " Note that subsequent logs will be logged at debug level.";
    }

    private void log(InternalLogLevel internalLogLevel, String string, Throwable throwable) {
        if (throwable != null) {
            this.logger.log(internalLogLevel, string, throwable);
        } else {
            this.logger.log(internalLogLevel, string);
        }
    }

    public void log(String string) {
        this.log(string, null);
    }

    public void log(Supplier<String> supplier, Throwable throwable) {
        if (this.warnLogged.compareAndSet(false, true)) {
            this.log(InternalLogLevel.WARN, this.getWarnMessage(supplier.get()), throwable);
        } else if (this.logger.isDebugEnabled()) {
            this.log(InternalLogLevel.DEBUG, supplier.get(), throwable);
        }
    }

    public void log(Supplier<String> supplier) {
        this.log(supplier, null);
    }
}

