/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public interface FunctionTimer
extends Meter {
    public static <T> Builder<T> builder(String string, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
        return new Builder(string, t2, toLongFunction, toDoubleFunction, timeUnit);
    }

    public double count();

    public double totalTime(TimeUnit var1);

    default public double mean(TimeUnit timeUnit) {
        double d2 = this.count();
        return d2 == 0.0 ? 0.0 : this.totalTime(timeUnit) / d2;
    }

    public TimeUnit baseTimeUnit();

    @Override
    default public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(this::count, Statistic.COUNT), new Measurement(() -> this.totalTime(this.baseTimeUnit()), Statistic.TOTAL_TIME));
    }

    public static class Builder<T> {
        private final String name;
        private final ToLongFunction<T> countFunction;
        private final ToDoubleFunction<T> totalTimeFunction;
        private final TimeUnit totalTimeFunctionUnit;
        private Tags tags = Tags.empty();
        @Nullable
        private final T obj;
        @Nullable
        private String description;

        private Builder(String string, @Nullable T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
            this.name = string;
            this.obj = t2;
            this.countFunction = toLongFunction;
            this.totalTimeFunction = toDoubleFunction;
            this.totalTimeFunctionUnit = timeUnit;
        }

        public Builder<T> tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder<T> tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder<T> tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder<T> description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public FunctionTimer register(MeterRegistry meterRegistry) {
            return meterRegistry.more().timer(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.TIMER), this.obj, this.countFunction, this.totalTimeFunction, this.totalTimeFunctionUnit);
        }
    }
}

