/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.StrongReferenceGaugeFunction;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import java.util.Collections;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public interface Gauge
extends Meter {
    public static <T> Builder<T> builder(String string, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        return new Builder(string, t2, toDoubleFunction);
    }

    @Incubating(since="1.1.0")
    public static Builder<Supplier<Number>> builder(String string, Supplier<Number> supplier2) {
        return new Builder(string, supplier2, supplier -> {
            Number number = (Number)supplier.get();
            return number == null ? Double.NaN : number.doubleValue();
        }).strongReference(true);
    }

    public double value();

    @Override
    default public Iterable<Measurement> measure() {
        return Collections.singletonList(new Measurement(this::value, Statistic.VALUE));
    }

    public static class Builder<T> {
        private final String name;
        private final ToDoubleFunction<T> f;
        private Tags tags = Tags.empty();
        private boolean strongReference = false;
        @Nullable
        private Meter.Id syntheticAssociation = null;
        @Nullable
        private final T obj;
        @Nullable
        private String description;
        @Nullable
        private String baseUnit;

        private Builder(String string, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
            this.name = string;
            this.obj = t2;
            this.f = toDoubleFunction;
        }

        public Builder<T> tags(String ... stringArray) {
            return this.tags(Tags.of(stringArray));
        }

        public Builder<T> tags(Iterable<Tag> iterable) {
            this.tags = this.tags.and(iterable);
            return this;
        }

        public Builder<T> tag(String string, String string2) {
            this.tags = this.tags.and(string, string2);
            return this;
        }

        public Builder<T> description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public Builder<T> baseUnit(@Nullable String string) {
            this.baseUnit = string;
            return this;
        }

        @Incubating(since="1.1.0")
        public Builder<T> synthetic(Meter.Id id) {
            this.syntheticAssociation = id;
            return this;
        }

        @Incubating(since="1.1.0")
        public Builder<T> strongReference(boolean bl2) {
            this.strongReference = bl2;
            return this;
        }

        public Gauge register(MeterRegistry meterRegistry) {
            return meterRegistry.gauge(new Meter.Id(this.name, this.tags, this.baseUnit, this.description, Meter.Type.GAUGE, this.syntheticAssociation), this.obj, this.strongReference ? new StrongReferenceGaugeFunction<T>(this.obj, this.f) : this.f);
        }
    }
}

