/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.cache;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.ref.WeakReference;

@NonNullApi
@NonNullFields
public abstract class CacheMeterBinder<C>
implements MeterBinder {
    private static final String DESCRIPTION_CACHE_GETS = "The number of times cache lookup methods have returned a cached (hit) or uncached (newly loaded or null) value (miss).";
    private final WeakReference<C> cacheRef;
    private final Iterable<Tag> tags;

    public CacheMeterBinder(C c2, String string, Iterable<Tag> iterable) {
        this.tags = Tags.concat(iterable, "cache", string);
        this.cacheRef = new WeakReference<C>(c2);
    }

    @Nullable
    protected C getCache() {
        return (C)this.cacheRef.get();
    }

    @Override
    public final void bindTo(MeterRegistry meterRegistry) {
        C c2 = this.getCache();
        if (this.size() != null) {
            Gauge.builder("cache.size", c2, object -> {
                Long l2 = this.size();
                return l2 == null ? 0.0 : (double)l2.longValue();
            }).tags(this.tags).description("The number of entries in this cache. This may be an approximation, depending on the type of cache.").register(meterRegistry);
        }
        if (this.missCount() != null) {
            FunctionCounter.builder("cache.gets", c2, object -> {
                Long l2 = this.missCount();
                return l2 == null ? 0.0 : (double)l2.longValue();
            }).tags(this.tags).tag("result", "miss").description(DESCRIPTION_CACHE_GETS).register(meterRegistry);
        }
        FunctionCounter.builder("cache.gets", c2, object -> this.hitCount()).tags(this.tags).tag("result", "hit").description(DESCRIPTION_CACHE_GETS).register(meterRegistry);
        FunctionCounter.builder("cache.puts", c2, object -> this.putCount()).tags(this.tags).description("The number of entries added to the cache").register(meterRegistry);
        if (this.evictionCount() != null) {
            FunctionCounter.builder("cache.evictions", c2, object -> {
                Long l2 = this.evictionCount();
                return l2 == null ? 0.0 : (double)l2.longValue();
            }).tags(this.tags).description("The number of times the cache was evicted.").register(meterRegistry);
        }
        this.bindImplementationSpecificMetrics(meterRegistry);
    }

    @Nullable
    protected abstract Long size();

    protected abstract long hitCount();

    @Nullable
    protected abstract Long missCount();

    @Nullable
    protected abstract Long evictionCount();

    protected abstract long putCount();

    protected abstract void bindImplementationSpecificMetrics(MeterRegistry var1);

    protected Iterable<Tag> getTagsWithCacheName() {
        return this.tags;
    }
}

