/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.cache;

import com.contrastsecurity.thirdparty.com.google.common.cache.Cache;
import com.contrastsecurity.thirdparty.com.google.common.cache.LoadingCache;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToLongFunction;

@NonNullApi
@NonNullFields
public class GuavaCacheMetrics<K, V, C extends Cache<K, V>>
extends CacheMeterBinder<C> {
    private static final String DESCRIPTION_CACHE_LOAD = "The number of times cache lookup methods have successfully loaded a new value or failed to load a new value because an exception was thrown while loading";

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry meterRegistry, C c2, String string, String ... stringArray) {
        return GuavaCacheMetrics.monitor(meterRegistry, c2, string, Tags.of(stringArray));
    }

    public static <K, V, C extends Cache<K, V>> C monitor(MeterRegistry meterRegistry, C c2, String string, Iterable<Tag> iterable) {
        new GuavaCacheMetrics<K, V, C>(c2, string, iterable).bindTo(meterRegistry);
        return c2;
    }

    public GuavaCacheMetrics(C c2, String string, Iterable<Tag> iterable) {
        super(c2, string, iterable);
    }

    @Override
    protected Long size() {
        return this.getOrDefault(Cache::size, null);
    }

    @Override
    protected long hitCount() {
        return this.getOrDefault((Cache<?, ?> cache) -> cache.stats().hitCount(), 0L);
    }

    @Override
    protected Long missCount() {
        return this.getOrDefault((Cache<?, ?> cache) -> cache.stats().missCount(), null);
    }

    @Override
    protected Long evictionCount() {
        return this.getOrDefault((Cache<?, ?> cache) -> cache.stats().evictionCount(), null);
    }

    @Override
    protected long putCount() {
        return this.getOrDefault((Cache<?, ?> cache) -> cache.stats().loadCount(), 0L);
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry meterRegistry) {
        Cache cache2 = (Cache)this.getCache();
        if (cache2 instanceof LoadingCache) {
            TimeGauge.builder("cache.load.duration", cache2, TimeUnit.NANOSECONDS, cache -> cache.stats().totalLoadTime()).tags(this.getTagsWithCacheName()).description("The time the cache has spent loading new values").register(meterRegistry);
            FunctionCounter.builder("cache.load", cache2, cache -> cache.stats().loadSuccessCount()).tags(this.getTagsWithCacheName()).tags("result", "success").description(DESCRIPTION_CACHE_LOAD).register(meterRegistry);
            FunctionCounter.builder("cache.load", cache2, cache -> cache.stats().loadExceptionCount()).tags(this.getTagsWithCacheName()).tags("result", "failure").description(DESCRIPTION_CACHE_LOAD).register(meterRegistry);
        }
    }

    @Nullable
    private Long getOrDefault(Function<Cache<?, ?>, Long> function, @Nullable Long l2) {
        Cache cache = (Cache)this.getCache();
        if (cache != null) {
            return function.apply(cache);
        }
        return l2;
    }

    private long getOrDefault(ToLongFunction<Cache<?, ?>> toLongFunction, long l2) {
        Cache cache = (Cache)this.getCache();
        if (cache != null) {
            return toLongFunction.applyAsLong(cache);
        }
        return l2;
    }
}

