/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.DefaultGrpcClientObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.GrpcClientObservationContext;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.GrpcClientObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.grpc.ObservationGrpcClientCall;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ObservationGrpcClientInterceptor
implements ClientInterceptor {
    private static final GrpcClientObservationConvention DEFAULT_CONVENTION = new DefaultGrpcClientObservationConvention();
    private static final Map<String, Metadata.Key<String>> KEY_CACHE = new ConcurrentHashMap<String, Metadata.Key<String>>();
    private final ObservationRegistry registry;
    @Nullable
    private GrpcClientObservationConvention customConvention;

    public ObservationGrpcClientInterceptor(ObservationRegistry observationRegistry) {
        this.registry = observationRegistry;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        Supplier<GrpcClientObservationContext> supplier = () -> {
            GrpcClientObservationContext grpcClientObservationContext = new GrpcClientObservationContext((metadata, string, string3) -> {
                Metadata.Key key = KEY_CACHE.computeIfAbsent(string, string2 -> Metadata.Key.of((String)string, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                metadata.removeAll(key);
                metadata.put(key, (Object)string3);
            });
            String string2 = methodDescriptor.getServiceName();
            String string4 = methodDescriptor.getBareMethodName();
            String string5 = methodDescriptor.getFullMethodName();
            MethodDescriptor.MethodType methodType = methodDescriptor.getType();
            if (string2 != null) {
                grpcClientObservationContext.setServiceName(string2);
            }
            if (string4 != null) {
                grpcClientObservationContext.setMethodName(string4);
            }
            grpcClientObservationContext.setFullMethodName(string5);
            grpcClientObservationContext.setMethodType(methodType);
            grpcClientObservationContext.setAuthority(channel.authority());
            return grpcClientObservationContext;
        };
        Observation observation = GrpcObservationDocumentation.CLIENT.observation(this.customConvention, DEFAULT_CONVENTION, supplier, this.registry);
        if (observation.isNoop()) {
            return channel.newCall(methodDescriptor, callOptions);
        }
        return new ObservationGrpcClientCall(channel.newCall(methodDescriptor, callOptions), observation);
    }

    public void setCustomConvention(@Nullable GrpcClientObservationConvention grpcClientObservationConvention) {
        this.customConvention = grpcClientObservationConvention;
    }
}

