/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jetty;

import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.common.util.StringUtils;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.http.Outcome;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpStatus;

public final class JettyClientKeyValues {
    private static final KeyValue URI_NOT_FOUND = KeyValue.of("uri", "NOT_FOUND");
    private static final KeyValue URI_REDIRECTION = KeyValue.of("uri", "REDIRECTION");
    private static final KeyValue URI_ROOT = KeyValue.of("uri", "root");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of("exception", "None");
    private static final KeyValue EXCEPTION_UNKNOWN = KeyValue.of("exception", "UNKNOWN");
    private static final KeyValue METHOD_UNKNOWN = KeyValue.of("method", "UNKNOWN");
    private static final KeyValue HOST_UNKNOWN = KeyValue.of("host", "UNKNOWN");
    private static final KeyValue STATUS_UNKNOWN = KeyValue.of("status", "UNKNOWN");
    private static final Pattern TRAILING_SLASH_PATTERN = Pattern.compile("/$");
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");
    private static final KeyValue OUTCOME_UNKNOWN = KeyValue.of("outcome", "UNKNOWN");

    private JettyClientKeyValues() {
    }

    public static KeyValue method(Request request) {
        return request != null ? KeyValue.of("method", request.getMethod()) : METHOD_UNKNOWN;
    }

    public static KeyValue host(Request request) {
        return request != null ? KeyValue.of("host", request.getHost()) : HOST_UNKNOWN;
    }

    public static KeyValue status(@Nullable Result result) {
        return result != null ? KeyValue.of("status", Integer.toString(result.getResponse().getStatus())) : STATUS_UNKNOWN;
    }

    public static KeyValue uri(Request request, @Nullable Result result, BiFunction<Request, Result, String> biFunction) {
        if (result != null && result.getResponse() != null) {
            int n2 = result.getResponse().getStatus();
            if (HttpStatus.isRedirection((int)n2)) {
                return URI_REDIRECTION;
            }
            if (n2 == 404) {
                return URI_NOT_FOUND;
            }
        }
        String string = biFunction.apply(request, result);
        if ((string = MULTIPLE_SLASH_PATTERN.matcher(string).replaceAll("/")).equals("/")) {
            return URI_ROOT;
        }
        string = TRAILING_SLASH_PATTERN.matcher(string).replaceAll("");
        return KeyValue.of("uri", string);
    }

    public static KeyValue exception(@Nullable Result result) {
        String string;
        int n2;
        if (result == null) {
            return EXCEPTION_UNKNOWN;
        }
        Throwable throwable = result.getFailure();
        if (throwable == null) {
            return EXCEPTION_NONE;
        }
        if (result.getResponse() != null && ((n2 = result.getResponse().getStatus()) == 404 || HttpStatus.isRedirection((int)n2))) {
            return EXCEPTION_NONE;
        }
        if (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return KeyValue.of("exception", StringUtils.isNotEmpty(string = throwable.getClass().getSimpleName()) ? string : throwable.getClass().getName());
    }

    public static KeyValue outcome(@Nullable Result result) {
        if (result == null) {
            return OUTCOME_UNKNOWN;
        }
        return Outcome.forStatus(result.getResponse().getStatus()).asKeyValue();
    }
}

