/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jetty;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowMax;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class JettyConnectionMetrics
extends AbstractLifeCycle
implements Connection.Listener {
    private final MeterRegistry registry;
    private final Iterable<Tag> tags;
    private final Object connectionSamplesLock = new Object();
    private final Map<Connection, Timer.Sample> connectionSamples = new HashMap<Connection, Timer.Sample>();
    private final Counter messagesIn;
    private final Counter messagesOut;
    private final DistributionSummary bytesIn;
    private final DistributionSummary bytesOut;
    private final TimeWindowMax maxConnections;

    public JettyConnectionMetrics(MeterRegistry meterRegistry) {
        this(meterRegistry, Tags.empty());
    }

    public JettyConnectionMetrics(MeterRegistry meterRegistry, Iterable<Tag> iterable) {
        this.registry = meterRegistry;
        this.tags = iterable;
        this.messagesIn = Counter.builder("jetty.connections.messages.in").baseUnit("messages").description("Messages received by tracked connections").tags(iterable).register(meterRegistry);
        this.messagesOut = Counter.builder("jetty.connections.messages.out").baseUnit("messages").description("Messages sent by tracked connections").tags(iterable).register(meterRegistry);
        this.bytesIn = DistributionSummary.builder("jetty.connections.bytes.in").baseUnit("bytes").description("Bytes received by tracked connections").tags(iterable).register(meterRegistry);
        this.bytesOut = DistributionSummary.builder("jetty.connections.bytes.out").baseUnit("bytes").description("Bytes sent by tracked connections").tags(iterable).register(meterRegistry);
        this.maxConnections = new TimeWindowMax(meterRegistry.config().clock(), DistributionStatisticConfig.DEFAULT);
        Gauge.builder("jetty.connections.max", this, jettyConnectionMetrics -> jettyConnectionMetrics.maxConnections.poll()).strongReference(true).baseUnit("connections").description("The maximum number of observed connections over a rolling 2-minute interval").tags(iterable).register(meterRegistry);
        Gauge.builder("jetty.connections.current", this, jettyConnectionMetrics -> jettyConnectionMetrics.connectionSamples.size()).strongReference(true).baseUnit("connections").description("The current number of open Jetty connections").tags(iterable).register(meterRegistry);
    }

    public JettyConnectionMetrics(MeterRegistry meterRegistry, Connector connector) {
        this(meterRegistry, connector, Tags.empty());
    }

    public JettyConnectionMetrics(MeterRegistry meterRegistry, Connector connector, Iterable<Tag> iterable) {
        this(meterRegistry, JettyConnectionMetrics.getConnectorNameTag(connector).and(iterable));
    }

    private static Tags getConnectorNameTag(Connector connector) {
        String string = connector.getName();
        return Tags.of("connector.name", string != null ? string : "unnamed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpened(Connection connection) {
        Timer.Sample sample = Timer.start(this.registry);
        Object object = this.connectionSamplesLock;
        synchronized (object) {
            this.connectionSamples.put(connection, sample);
            this.maxConnections.record((double)this.connectionSamples.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(Connection connection) {
        Timer.Sample sample;
        Object object = this.connectionSamplesLock;
        synchronized (object) {
            sample = this.connectionSamples.remove(connection);
        }
        if (sample != null) {
            object = connection instanceof HttpConnection ? "server" : "client";
            sample.stop(((Timer.Builder)Timer.builder("jetty.connections.request").description("Jetty client or server requests").tag("type", (String)object).tags((Iterable)this.tags)).register(this.registry));
        }
        this.messagesIn.increment(connection.getMessagesIn());
        this.messagesOut.increment(connection.getMessagesOut());
        this.bytesIn.record(connection.getBytesIn());
        this.bytesOut.record(connection.getBytesOut());
    }

    public static void addToAllConnectors(Server server, MeterRegistry meterRegistry, Iterable<Tag> iterable) {
        for (Connector connector : server.getConnectors()) {
            if (connector == null) continue;
            connector.addBean((Object)new JettyConnectionMetrics(meterRegistry, connector, iterable));
        }
    }

    public static void addToAllConnectors(Server server, MeterRegistry meterRegistry) {
        JettyConnectionMetrics.addToAllConnectors(server, meterRegistry, Tags.empty());
    }
}

