/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jetty;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.http.DefaultHttpServletRequestTagsProvider;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.http.HttpServletRequestTagsProvider;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.binder.jetty.OnCompletionAsyncListener;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.component.Graceful;

@NonNullApi
@NonNullFields
public class TimedHandler
extends HandlerWrapper
implements Graceful {
    private static final String SAMPLE_REQUEST_TIMER_ATTRIBUTE = "__micrometer_timer_sample";
    private static final String SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE = "__micrometer_ltt_sample";
    private final MeterRegistry registry;
    private final Iterable<Tag> tags;
    private final HttpServletRequestTagsProvider tagsProvider;
    private final Graceful.Shutdown shutdown = new Graceful.Shutdown(){

        protected FutureCallback newShutdownCallback() {
            return TimedHandler.this.newShutdownCallback();
        }
    };
    private final LongTaskTimer openRequests;
    private final Counter asyncDispatches;
    private final Counter asyncExpires;
    private final AtomicInteger asyncWaits = new AtomicInteger();
    private final AsyncListener onCompletion = new OnCompletionAsyncListener((Object)this);

    public TimedHandler(MeterRegistry meterRegistry, Iterable<Tag> iterable) {
        this(meterRegistry, iterable, new DefaultHttpServletRequestTagsProvider());
    }

    public TimedHandler(MeterRegistry meterRegistry, Iterable<Tag> iterable, HttpServletRequestTagsProvider httpServletRequestTagsProvider) {
        this.registry = meterRegistry;
        this.tags = iterable;
        this.tagsProvider = httpServletRequestTagsProvider;
        this.openRequests = LongTaskTimer.builder("jetty.server.dispatches.open").description("Jetty dispatches that are currently in progress").tags(iterable).register(meterRegistry);
        this.asyncDispatches = Counter.builder("jetty.server.async.dispatches").description("Asynchronous dispatches").tags(iterable).register(meterRegistry);
        this.asyncExpires = Counter.builder("jetty.server.async.expires").description("Asynchronous operations that timed out before completing").tags(iterable).register(meterRegistry);
        Gauge.builder("jetty.server.async.waits", this.asyncWaits, AtomicInteger::doubleValue).description("Pending asynchronous wait operations").baseUnit("operations").tags(iterable).register(meterRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String string, Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Handler handler;
        LongTaskTimer.Sample sample;
        Timer.Sample sample2 = Timer.start(this.registry);
        HttpChannelState httpChannelState = request.getHttpChannelState();
        if (httpChannelState.isInitial()) {
            sample = this.openRequests.start();
            httpServletRequest.setAttribute(SAMPLE_REQUEST_TIMER_ATTRIBUTE, (Object)sample2);
            httpServletRequest.setAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE, (Object)sample);
        } else {
            this.asyncDispatches.increment();
            httpServletRequest.setAttribute(SAMPLE_REQUEST_TIMER_ATTRIBUTE, (Object)sample2);
            sample = (LongTaskTimer.Sample)httpServletRequest.getAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE);
        }
        try {
            handler = this.getHandler();
            if (handler != null && !this.shutdown.isShutdown() && this.isStarted()) {
                handler.handle(string, request, httpServletRequest, httpServletResponse);
            } else {
                if (!request.isHandled()) {
                    request.setHandled(true);
                }
                if (!request.getResponse().isCommitted()) {
                    httpServletResponse.sendError(503);
                }
            }
        }
        finally {
            if (httpChannelState.isSuspended()) {
                if (httpChannelState.isInitial()) {
                    httpChannelState.addListener(this.onCompletion);
                    this.asyncWaits.incrementAndGet();
                }
            } else if (httpChannelState.isInitial()) {
                sample2.stop(((Timer.Builder)((Timer.Builder)Timer.builder("jetty.server.requests").description("HTTP requests to the Jetty server").tags((Iterable)this.tagsProvider.getTags(httpServletRequest, httpServletResponse))).tags((Iterable)this.tags)).register(this.registry));
                sample.stop();
                handler = this.shutdown.get();
                if (handler != null) {
                    httpServletResponse.flushBuffer();
                    if (this.openRequests.activeTasks() == 0) {
                        handler.succeeded();
                    }
                }
            }
        }
    }

    protected void doStart() throws Exception {
        this.shutdown.cancel();
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.shutdown.cancel();
        super.doStop();
    }

    public Future<Void> shutdown() {
        return this.shutdown.shutdown();
    }

    public boolean isShutdown() {
        return this.shutdown.isShutdown();
    }

    void onAsyncTimeout(AsyncEvent asyncEvent) {
        this.asyncExpires.increment();
        HttpChannelState httpChannelState = ((AsyncContextEvent)asyncEvent).getHttpChannelState();
        Request request = httpChannelState.getBaseRequest();
        LongTaskTimer.Sample sample = (LongTaskTimer.Sample)request.getAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE);
        sample.stop();
    }

    void onAsyncComplete(AsyncEvent asyncEvent) {
        HttpChannelState httpChannelState = ((AsyncContextEvent)asyncEvent).getHttpChannelState();
        Request request = httpChannelState.getBaseRequest();
        Timer.Sample sample = (Timer.Sample)request.getAttribute(SAMPLE_REQUEST_TIMER_ATTRIBUTE);
        LongTaskTimer.Sample sample2 = (LongTaskTimer.Sample)request.getAttribute(SAMPLE_REQUEST_LONG_TASK_TIMER_ATTRIBUTE);
        if (sample != null) {
            sample.stop(((Timer.Builder)((Timer.Builder)Timer.builder("jetty.server.requests").description("HTTP requests to the Jetty server").tags((Iterable)this.tagsProvider.getTags((HttpServletRequest)request, (HttpServletResponse)request.getResponse()))).tags((Iterable)this.tags)).register(this.registry));
            sample2.stop();
        }
        this.asyncWaits.decrementAndGet();
        FutureCallback futureCallback = this.shutdown.get();
        if (futureCallback != null && this.openRequests.activeTasks() == 0) {
            futureCallback.succeeded();
        }
    }

    private FutureCallback newShutdownCallback() {
        return new FutureCallback(this.openRequests.activeTasks() == 0);
    }
}

