/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.composite;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.composite.AbstractCompositeMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.noop.NoopFunctionTimer;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

class CompositeFunctionTimer<T>
extends AbstractCompositeMeter<FunctionTimer>
implements FunctionTimer {
    private final WeakReference<T> ref;
    private final ToLongFunction<T> countFunction;
    private final ToDoubleFunction<T> totalTimeFunction;
    private final TimeUnit totalTimeFunctionUnit;

    CompositeFunctionTimer(Meter.Id id, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
        super(id);
        this.ref = new WeakReference<T>(t2);
        this.countFunction = toLongFunction;
        this.totalTimeFunction = toDoubleFunction;
        this.totalTimeFunctionUnit = timeUnit;
    }

    @Override
    public double count() {
        return ((FunctionTimer)this.firstChild()).count();
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        return ((FunctionTimer)this.firstChild()).totalTime(timeUnit);
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return ((FunctionTimer)this.firstChild()).baseTimeUnit();
    }

    @Override
    FunctionTimer newNoopMeter() {
        return new NoopFunctionTimer(this.getId());
    }

    @Override
    FunctionTimer registerNewMeter(MeterRegistry meterRegistry) {
        Object t2 = this.ref.get();
        if (t2 == null) {
            return null;
        }
        return FunctionTimer.builder(this.getId().getName(), t2, this.countFunction, this.totalTimeFunction, this.totalTimeFunctionUnit).tags(this.getId().getTagsAsIterable()).description(this.getId().getDescription()).register(meterRegistry);
    }
}

