/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.TimeWindowMax;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CumulativeTimer
extends AbstractTimer {
    private final AtomicLong count = new AtomicLong();
    private final AtomicLong total = new AtomicLong();
    private final TimeWindowMax max;

    public CumulativeTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit) {
        this(id, clock, distributionStatisticConfig, pauseDetector, timeUnit, false);
    }

    public CumulativeTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit, boolean bl2) {
        this(id, clock, distributionStatisticConfig, pauseDetector, timeUnit, AbstractTimer.defaultHistogram(clock, distributionStatisticConfig, bl2));
    }

    protected CumulativeTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit, Histogram histogram) {
        super(id, clock, pauseDetector, timeUnit, histogram);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(long l2, TimeUnit timeUnit) {
        long l3 = (long)TimeUtils.convert(l2, timeUnit, TimeUnit.NANOSECONDS);
        this.count.getAndAdd(1L);
        this.total.getAndAdd(l3);
        this.max.record(l3, TimeUnit.NANOSECONDS);
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.total.get(), timeUnit);
    }

    @Override
    public double max(TimeUnit timeUnit) {
        return this.max.poll(timeUnit);
    }
}

