/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.Histogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.DoubleAdder;

public class FixedBoundaryVictoriaMetricsHistogram
implements Histogram {
    private static final IdxOffset UPPER = new IdxOffset(-1, 2);
    private static final IdxOffset LOWER = new IdxOffset(-1, 1);
    private static final IdxOffset ZERO = new IdxOffset(-1, 0);
    private static final int E10MIN = -9;
    private static final int E10MAX = 18;
    private static final int DECIMAL_MULTIPLIER = 2;
    private static final int BUCKET_SIZE = 18;
    private static final int BUCKETS_COUNT = 27;
    private static final double DECIMAL_PRECISION = 0.005;
    private static final String[] VMRANGES = new String[489];
    private static final double[] UPPER_BOUNDS;
    final AtomicReferenceArray<AtomicLongArray> values;
    final AtomicLong zeros = new AtomicLong();
    final AtomicLong lower = new AtomicLong();
    final AtomicLong upper = new AtomicLong();
    final DoubleAdder sum = new DoubleAdder();

    public FixedBoundaryVictoriaMetricsHistogram() {
        this.values = new AtomicReferenceArray(27);
    }

    @Override
    public void recordLong(long l2) {
        this.recordDouble(l2);
    }

    @Override
    public void recordDouble(double d2) {
        if (Double.isNaN(d2) || d2 < 0.0) {
            return;
        }
        IdxOffset idxOffset = FixedBoundaryVictoriaMetricsHistogram.getBucketIdxAndOffset(d2);
        this.sum.add(d2);
        if (idxOffset.bucketIdx < 0) {
            if (idxOffset.offset == 0) {
                this.zeros.incrementAndGet();
            } else if (idxOffset.offset == 1) {
                this.lower.incrementAndGet();
            } else {
                this.upper.incrementAndGet();
            }
            return;
        }
        AtomicLongArray atomicLongArray = this.values.get(idxOffset.bucketIdx);
        if (atomicLongArray == null && !this.values.compareAndSet(idxOffset.bucketIdx, null, atomicLongArray = new AtomicLongArray(18))) {
            atomicLongArray = this.values.get(idxOffset.bucketIdx);
        }
        atomicLongArray.incrementAndGet(idxOffset.offset);
    }

    private static IdxOffset getBucketIdxAndOffset(double d2) {
        if (d2 < 0.0) {
            throw new RuntimeException(String.format("BUG: v must be positive; got %f", d2));
        }
        if (d2 == 0.0) {
            return ZERO;
        }
        if (Double.POSITIVE_INFINITY == d2) {
            return UPPER;
        }
        int n2 = (int)Math.floor(Math.log10(d2));
        int n3 = n2 - -9;
        if (n3 < 0) {
            return LOWER;
        }
        double d3 = Math.pow(10.0, n2);
        if (n3 >= 27) {
            if (n3 == 27 && Math.abs(d3 - d2) < 0.005) {
                return new IdxOffset(26, 17);
            }
            return UPPER;
        }
        double d4 = (d2 / d3 - 1.0) * 2.0;
        int n4 = (int)d4;
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 >= 18) {
            n4 = 17;
        }
        if (Math.abs((double)n4 - d4) < 0.005 && --n4 < 0) {
            if (--n3 < 0) {
                return LOWER;
            }
            n4 = 17;
        }
        return new IdxOffset(n3, n4);
    }

    private static int getRangeIndex(int n2, int n3) {
        if (n2 < 0) {
            if (n3 > 2) {
                throw new RuntimeException(String.format("BUG: offset must be in range [0...2] for negative bucketIdx; got %d", n3));
            }
            return n3;
        }
        return 3 + n2 * 18 + n3;
    }

    public static String getRangeTagValue(double d2) {
        IdxOffset idxOffset = FixedBoundaryVictoriaMetricsHistogram.getBucketIdxAndOffset(d2);
        return VMRANGES[FixedBoundaryVictoriaMetricsHistogram.getRangeIndex(idxOffset.bucketIdx, idxOffset.offset)];
    }

    private List<CountAtBucket> nonZeroBuckets() {
        long l2;
        long l3;
        ArrayList<CountAtBucket> arrayList = new ArrayList<CountAtBucket>();
        long l4 = this.zeros.get();
        if (l4 > 0L) {
            arrayList.add(new CountAtBucket(UPPER_BOUNDS[FixedBoundaryVictoriaMetricsHistogram.getRangeIndex(FixedBoundaryVictoriaMetricsHistogram.ZERO.bucketIdx, FixedBoundaryVictoriaMetricsHistogram.ZERO.offset)], (double)l4));
        }
        if ((l3 = this.lower.get()) > 0L) {
            arrayList.add(new CountAtBucket(UPPER_BOUNDS[FixedBoundaryVictoriaMetricsHistogram.getRangeIndex(FixedBoundaryVictoriaMetricsHistogram.LOWER.bucketIdx, FixedBoundaryVictoriaMetricsHistogram.LOWER.offset)], (double)l3));
        }
        if ((l2 = this.upper.get()) > 0L) {
            arrayList.add(new CountAtBucket(UPPER_BOUNDS[FixedBoundaryVictoriaMetricsHistogram.getRangeIndex(FixedBoundaryVictoriaMetricsHistogram.UPPER.bucketIdx, FixedBoundaryVictoriaMetricsHistogram.UPPER.offset)], (double)l2));
        }
        for (int i2 = 0; i2 < this.values.length(); ++i2) {
            AtomicLongArray atomicLongArray = this.values.get(i2);
            if (atomicLongArray == null) continue;
            for (int i3 = 0; i3 < atomicLongArray.length(); ++i3) {
                long l5 = atomicLongArray.get(i3);
                if (l5 <= 0L) continue;
                arrayList.add(new CountAtBucket(UPPER_BOUNDS[FixedBoundaryVictoriaMetricsHistogram.getRangeIndex(i2, i3)], (double)l5));
            }
        }
        return arrayList;
    }

    @Override
    public HistogramSnapshot takeSnapshot(long l2, double d2, double d3) {
        return new HistogramSnapshot(l2, d2, d3, null, this.nonZeroBuckets().toArray(new CountAtBucket[0]), this::outputSummary);
    }

    private void outputSummary(PrintStream printStream, double d2) {
        printStream.format("%14s %10s\n\n", "Bucket", "TotalCount");
        for (CountAtBucket countAtBucket : this.nonZeroBuckets()) {
            printStream.format(Locale.US, "%14.1f %10d\n", countAtBucket.bucket() / d2, countAtBucket.count());
        }
        printStream.write(10);
    }

    static {
        FixedBoundaryVictoriaMetricsHistogram.VMRANGES[0] = "0...0";
        FixedBoundaryVictoriaMetricsHistogram.VMRANGES[1] = String.format(Locale.US, "0...%.1fe%d", 1.0, -9);
        FixedBoundaryVictoriaMetricsHistogram.VMRANGES[2] = String.format(Locale.US, "%.1fe%d...+Inf", 1.0, 18);
        UPPER_BOUNDS = new double[489];
        FixedBoundaryVictoriaMetricsHistogram.UPPER_BOUNDS[0] = 0.0;
        FixedBoundaryVictoriaMetricsHistogram.UPPER_BOUNDS[1] = BigDecimal.TEN.pow(-9, MathContext.DECIMAL128).doubleValue();
        FixedBoundaryVictoriaMetricsHistogram.UPPER_BOUNDS[2] = Double.POSITIVE_INFINITY;
        int n2 = 3;
        String string = String.format(Locale.US, "%.1fe%d", 1.0, -9);
        for (int i2 = 0; i2 < 27; ++i2) {
            for (int i3 = 0; i3 < 18; ++i3) {
                int n3 = -9 + i2;
                double d2 = 1.0 + (double)(i3 + 1) / 2.0;
                if (Math.abs(d2 - 10.0) < 0.005) {
                    d2 = 1.0;
                    ++n3;
                }
                String string2 = String.format(Locale.US, "%.1fe%d", d2, n3);
                FixedBoundaryVictoriaMetricsHistogram.VMRANGES[n2] = string + "..." + string2;
                FixedBoundaryVictoriaMetricsHistogram.UPPER_BOUNDS[n2] = BigDecimal.valueOf(d2).setScale(1, RoundingMode.HALF_UP).multiply(BigDecimal.TEN.pow(n3, MathContext.DECIMAL128)).doubleValue();
                ++n2;
                string = string2;
            }
        }
    }

    private static class IdxOffset {
        final int bucketIdx;
        final int offset;

        IdxOffset(int n2, int n3) {
            this.bucketIdx = n2;
            this.offset = n3;
        }
    }
}

