/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution;

import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.AbstractTimeWindowHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.CountAtBucket;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.FixedBoundaryHistogram;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.PercentileHistogramBuckets;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Objects;

public class TimeWindowFixedBoundaryHistogram
extends AbstractTimeWindowHistogram<FixedBoundaryHistogram, Void> {
    private final double[] buckets;
    private final boolean isCumulativeBucketCounts;

    public TimeWindowFixedBoundaryHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean bl2) {
        this(clock, distributionStatisticConfig, bl2, true);
    }

    public TimeWindowFixedBoundaryHistogram(Clock clock, DistributionStatisticConfig distributionStatisticConfig, boolean bl2, boolean bl3) {
        super(clock, distributionStatisticConfig, FixedBoundaryHistogram.class, bl2);
        this.isCumulativeBucketCounts = bl3;
        NavigableSet<Double> navigableSet = this.distributionStatisticConfig.getHistogramBuckets(bl2);
        Boolean bl4 = this.distributionStatisticConfig.isPercentileHistogram();
        if (bl4 != null && bl4.booleanValue()) {
            navigableSet.addAll(PercentileHistogramBuckets.buckets(this.distributionStatisticConfig));
        }
        this.buckets = navigableSet.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).toArray();
        this.initRingBuffer();
    }

    @Override
    FixedBoundaryHistogram newBucket() {
        return new FixedBoundaryHistogram(this.buckets, this.isCumulativeBucketCounts);
    }

    @Override
    void recordLong(FixedBoundaryHistogram fixedBoundaryHistogram, long l2) {
        fixedBoundaryHistogram.record(l2);
    }

    @Override
    final void recordDouble(FixedBoundaryHistogram fixedBoundaryHistogram, double d2) {
        this.recordLong(fixedBoundaryHistogram, (long)Math.ceil(d2));
    }

    @Override
    void resetBucket(FixedBoundaryHistogram fixedBoundaryHistogram) {
        fixedBoundaryHistogram.reset();
    }

    Void newAccumulatedHistogram(FixedBoundaryHistogram[] fixedBoundaryHistogramArray) {
        return null;
    }

    @Override
    void accumulate() {
    }

    @Override
    void resetAccumulatedHistogram() {
    }

    @Override
    double valueAtPercentile(double d2) {
        return 0.0;
    }

    @Override
    Iterator<CountAtBucket> countsAtValues(Iterator<Double> iterator) {
        return ((FixedBoundaryHistogram)this.currentHistogram()).countsAtValues(iterator);
    }

    @Override
    void outputSummary(PrintStream printStream, double d2) {
        printStream.format("%14s %10s\n\n", "Bucket", "TotalCount");
        String string = "%14.1f %10d\n";
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            printStream.format(Locale.US, string, this.buckets[i2] / d2, ((FixedBoundaryHistogram)this.currentHistogram()).values.get(i2));
        }
        printStream.write(10);
    }

    protected double[] getBuckets() {
        return this.buckets;
    }
}

