/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.observation;

import com.contrastsecurity.thirdparty.io.micrometer.common.KeyValue;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.observation.MeterObservationHandler;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import java.util.ArrayList;
import java.util.List;

public class DefaultMeterObservationHandler
implements MeterObservationHandler<Observation.Context> {
    private final MeterRegistry meterRegistry;

    public DefaultMeterObservationHandler(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void onStart(Observation.Context context) {
        LongTaskTimer.Sample sample = LongTaskTimer.builder(context.getName() + ".active").tags(this.createTags(context)).register(this.meterRegistry).start();
        context.put(LongTaskTimer.Sample.class, sample);
        Timer.Sample sample2 = Timer.start(this.meterRegistry);
        context.put(Timer.Sample.class, sample2);
    }

    @Override
    public void onStop(Observation.Context context) {
        List<Tag> list = this.createTags(context);
        list.add(Tag.of("error", this.getErrorValue(context)));
        Timer.Sample sample = (Timer.Sample)context.getRequired(Timer.Sample.class);
        sample.stop(((Timer.Builder)Timer.builder(context.getName()).tags(list)).register(this.meterRegistry));
        LongTaskTimer.Sample sample2 = (LongTaskTimer.Sample)context.getRequired(LongTaskTimer.Sample.class);
        sample2.stop();
    }

    @Override
    public void onEvent(Observation.Event event, Observation.Context context) {
        Counter.builder(context.getName() + "." + event.getName()).tags(this.createTags(context)).register(this.meterRegistry).increment();
    }

    private String getErrorValue(Observation.Context context) {
        Throwable throwable = context.getError();
        return throwable != null ? throwable.getClass().getSimpleName() : "none";
    }

    private List<Tag> createTags(Observation.Context context) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (KeyValue keyValue : context.getLowCardinalityKeyValues()) {
            arrayList.add(Tag.of(keyValue.getKey(), keyValue.getValue()));
        }
        return arrayList;
    }
}

