/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.observation;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.observation.transport.ResponseContext;
import java.util.function.Supplier;

public class ObservationOrTimerCompatibleInstrumentation<T extends Observation.Context> {
    private final MeterRegistry meterRegistry;
    private final ObservationRegistry observationRegistry;
    @Nullable
    private final ObservationConvention<T> convention;
    private final ObservationConvention<T> defaultConvention;
    @Nullable
    private Timer.Sample timerSample;
    @Nullable
    private Observation observation;
    @Nullable
    private T context;
    @Nullable
    private Throwable throwable;

    public static <T extends Observation.Context> ObservationOrTimerCompatibleInstrumentation<T> start(MeterRegistry meterRegistry, @Nullable ObservationRegistry observationRegistry, Supplier<T> supplier, @Nullable ObservationConvention<T> observationConvention, ObservationConvention<T> observationConvention2) {
        ObservationOrTimerCompatibleInstrumentation<T> observationOrTimerCompatibleInstrumentation = new ObservationOrTimerCompatibleInstrumentation<T>(meterRegistry, observationRegistry, observationConvention, observationConvention2);
        super.start(supplier);
        return observationOrTimerCompatibleInstrumentation;
    }

    private ObservationOrTimerCompatibleInstrumentation(MeterRegistry meterRegistry, @Nullable ObservationRegistry observationRegistry, @Nullable ObservationConvention<T> observationConvention, ObservationConvention<T> observationConvention2) {
        this.meterRegistry = meterRegistry;
        this.observationRegistry = observationRegistry == null ? ObservationRegistry.NOOP : observationRegistry;
        this.convention = observationConvention;
        this.defaultConvention = observationConvention2;
    }

    private void start(Supplier<T> supplier) {
        if (this.observationRegistry.isNoop()) {
            this.timerSample = Timer.start(this.meterRegistry);
        } else {
            this.observation = Observation.start(this.convention, this.defaultConvention, supplier, this.observationRegistry);
            this.context = this.observation.getContext();
        }
    }

    public <RES> void setResponse(RES RES) {
        if (this.observationRegistry.isNoop() || !(this.context instanceof ResponseContext)) {
            return;
        }
        ResponseContext responseContext = (ResponseContext)this.context;
        responseContext.setResponse(RES);
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public void stop(String string, @Nullable String string2, Supplier<Iterable<Tag>> supplier) {
        if (this.observationRegistry.isNoop() && this.timerSample != null) {
            this.timerSample.stop(((Timer.Builder)Timer.builder(string).description(string2).tags((Iterable)supplier.get())).register(this.meterRegistry));
        } else if (this.observation != null) {
            if (this.throwable != null) {
                this.observation.error(this.throwable);
            }
            this.observation.stop();
        }
    }
}

