/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.search;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tags;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.TimeGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.search.MeterNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RequiredSearch {
    final MeterRegistry registry;
    final List<Tag> requiredTags = new ArrayList<Tag>();
    final Set<String> requiredTagKeys = new HashSet<String>();
    @Nullable
    String exactNameMatch;
    @Nullable
    Predicate<String> nameMatches;

    private RequiredSearch(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
    }

    public RequiredSearch name(String string) {
        this.nameMatches = string2 -> string2.equals(string);
        this.exactNameMatch = string;
        return this;
    }

    public RequiredSearch name(Predicate<String> predicate) {
        this.nameMatches = predicate;
        return this;
    }

    public RequiredSearch tags(Iterable<Tag> iterable) {
        iterable.forEach(this.requiredTags::add);
        return this;
    }

    public RequiredSearch tags(String ... stringArray) {
        return this.tags(Tags.of(stringArray));
    }

    public RequiredSearch tag(String string, String string2) {
        return this.tags(Tags.of(string, string2));
    }

    public RequiredSearch tagKeys(String ... stringArray) {
        Collections.addAll(this.requiredTagKeys, stringArray);
        return this;
    }

    public Timer timer() {
        return this.getOne(Timer.class);
    }

    public Counter counter() {
        return this.getOne(Counter.class);
    }

    public Gauge gauge() {
        return this.getOne(Gauge.class);
    }

    public FunctionCounter functionCounter() {
        return this.getOne(FunctionCounter.class);
    }

    public TimeGauge timeGauge() {
        return this.getOne(TimeGauge.class);
    }

    public FunctionTimer functionTimer() {
        return this.getOne(FunctionTimer.class);
    }

    public DistributionSummary summary() {
        return this.getOne(DistributionSummary.class);
    }

    public LongTaskTimer longTaskTimer() {
        return this.getOne(LongTaskTimer.class);
    }

    public Meter meter() {
        return this.getOne(Meter.class);
    }

    private <M extends Meter> M getOne(Class<M> clazz) {
        return (M)this.meterStream().filter(clazz::isInstance).findAny().map(clazz::cast).orElseThrow(() -> MeterNotFoundException.forSearch(this, clazz));
    }

    private <M extends Meter> Collection<M> findAll(Class<M> clazz) {
        List list = this.meterStream().filter(clazz::isInstance).map(clazz::cast).collect(Collectors.toList());
        if (list.isEmpty()) {
            throw MeterNotFoundException.forSearch(this, clazz);
        }
        return list;
    }

    public Collection<Meter> meters() {
        List<Meter> list = this.meterStream().collect(Collectors.toList());
        if (list.isEmpty()) {
            throw MeterNotFoundException.forSearch(this, Meter.class);
        }
        return list;
    }

    private Stream<Meter> meterStream() {
        Stream<Meter> stream = this.registry.getMeters().stream().filter(meter -> this.nameMatches == null || this.nameMatches.test(meter.getId().getName()));
        if (!this.requiredTags.isEmpty() || !this.requiredTagKeys.isEmpty()) {
            stream = stream.filter(meter -> {
                boolean bl2 = true;
                if (!this.requiredTagKeys.isEmpty()) {
                    ArrayList arrayList = new ArrayList();
                    meter.getId().getTagsAsIterable().forEach(tag -> arrayList.add(tag.getKey()));
                    bl2 = arrayList.containsAll(this.requiredTagKeys);
                }
                return bl2 && meter.getId().getTags().containsAll(this.requiredTags);
            });
        }
        return stream;
    }

    public Collection<Counter> counters() {
        return this.findAll(Counter.class);
    }

    public Collection<Gauge> gauges() {
        return this.findAll(Gauge.class);
    }

    public Collection<Timer> timers() {
        return this.findAll(Timer.class);
    }

    public Collection<DistributionSummary> summaries() {
        return this.findAll(DistributionSummary.class);
    }

    public Collection<LongTaskTimer> longTaskTimers() {
        return this.findAll(LongTaskTimer.class);
    }

    public Collection<FunctionCounter> functionCounters() {
        return this.findAll(FunctionCounter.class);
    }

    public Collection<FunctionTimer> functionTimers() {
        return this.findAll(FunctionTimer.class);
    }

    public Collection<TimeGauge> timeGauges() {
        return this.findAll(TimeGauge.class);
    }

    public static RequiredSearch in(MeterRegistry meterRegistry) {
        return new RequiredSearch(meterRegistry);
    }
}

