/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.core.instrument.simple;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.AbstractTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Clock;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Counter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.DistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.FunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.LongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Measurement;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Meter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Statistic;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Tag;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.Timer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.cumulative.CumulativeTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.HistogramGauges;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultGauge;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.internal.DefaultMeter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.simple.SimpleConfig;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepDistributionSummary;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepFunctionCounter;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepFunctionTimer;
import com.contrastsecurity.thirdparty.io.micrometer.core.instrument.step.StepTimer;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class SimpleMeterRegistry
extends MeterRegistry {
    private final SimpleConfig config;

    public SimpleMeterRegistry() {
        this(SimpleConfig.DEFAULT, Clock.SYSTEM);
    }

    public SimpleMeterRegistry(SimpleConfig simpleConfig, Clock clock) {
        super(clock);
        simpleConfig.requireValid();
        this.config = simpleConfig;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double d2) {
        AbstractDistributionSummary abstractDistributionSummary;
        DistributionStatisticConfig distributionStatisticConfig2 = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                abstractDistributionSummary = new CumulativeDistributionSummary(id, this.clock, distributionStatisticConfig2, d2, false);
                break;
            }
            default: {
                abstractDistributionSummary = new StepDistributionSummary(id, this.clock, distributionStatisticConfig2, d2, this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat(abstractDistributionSummary, (MeterRegistry)this);
        return abstractDistributionSummary;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> iterable) {
        return new DefaultMeter(id, type, iterable);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        AbstractTimer abstractTimer;
        DistributionStatisticConfig distributionStatisticConfig2 = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                abstractTimer = new CumulativeTimer(id, this.clock, distributionStatisticConfig2, pauseDetector, this.getBaseTimeUnit(), false);
                break;
            }
            default: {
                abstractTimer = new StepTimer(id, this.clock, distributionStatisticConfig2, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat(abstractTimer, (MeterRegistry)this);
        return abstractTimer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T t2, ToDoubleFunction<T> toDoubleFunction) {
        return new DefaultGauge<T>(id, t2, toDoubleFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeCounter(id);
            }
        }
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer defaultLongTaskTimer = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        HistogramGauges.registerWithCommonFormat(defaultLongTaskTimer, (MeterRegistry)this);
        return defaultLongTaskTimer;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T t2, ToLongFunction<T> toLongFunction, ToDoubleFunction<T> toDoubleFunction, TimeUnit timeUnit) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionTimer<T>(id, t2, toLongFunction, toDoubleFunction, timeUnit, this.getBaseTimeUnit());
            }
        }
        return new StepFunctionTimer<T>(id, this.clock, this.config.step().toMillis(), t2, toLongFunction, toDoubleFunction, timeUnit, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T t2, ToDoubleFunction<T> toDoubleFunction) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionCounter<T>(id, t2, toDoubleFunction);
            }
        }
        return new StepFunctionCounter<T>(id, this.clock, this.config.step().toMillis(), t2, toDoubleFunction);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }

    @Incubating(since="1.9.0")
    public String getMetersAsString() {
        return this.getMeters().stream().sorted(Comparator.comparing(meter -> meter.getId().getName())).map(this::toString).collect(Collectors.joining("\n"));
    }

    private String toString(Meter meter) {
        Meter.Id id = meter.getId();
        String string = id.getTags().stream().map(this::toString).collect(Collectors.joining(", "));
        String string2 = id.getBaseUnit();
        String string3 = string2 != null ? " " + string2 : "";
        String string4 = StreamSupport.stream(meter.measure().spliterator(), false).map(measurement -> this.toString((Measurement)measurement, string3)).collect(Collectors.joining(", "));
        return String.format("%s(%s)[%s]; %s", new Object[]{id.getName(), id.getType(), string, string4});
    }

    private String toString(Tag tag) {
        return String.format("%s='%s'", tag.getKey(), tag.getValue());
    }

    private String toString(Measurement measurement, String string) {
        Statistic statistic = measurement.getStatistic();
        return String.format("%s=%s%s", statistic.toString().toLowerCase(), measurement.getValue(), this.getUnitSuffix(statistic, string));
    }

    private String getUnitSuffix(Statistic statistic, String string) {
        switch (statistic) {
            case DURATION: 
            case TOTAL_TIME: 
            case TOTAL: 
            case MAX: 
            case VALUE: {
                return string;
            }
        }
        return "";
    }
}

