/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.observation;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface ObservationHandler<T extends Observation.Context> {
    default public void onStart(T t2) {
    }

    default public void onError(T t2) {
    }

    default public void onEvent(Observation.Event event, T t2) {
    }

    default public void onScopeOpened(T t2) {
    }

    default public void onScopeClosed(T t2) {
    }

    default public void onScopeReset(T t2) {
    }

    default public void onStop(T t2) {
    }

    public boolean supportsContext(Observation.Context var1);

    public static class AllMatchingCompositeObservationHandler
    implements CompositeObservationHandler {
        private final List<ObservationHandler<Observation.Context>> handlers;

        @SafeVarargs
        public AllMatchingCompositeObservationHandler(ObservationHandler<? extends Observation.Context> ... observationHandlerArray) {
            this(Arrays.asList(observationHandlerArray));
        }

        public AllMatchingCompositeObservationHandler(List<? extends ObservationHandler<? extends Observation.Context>> list) {
            ArrayList<ObservationHandler<Observation.Context>> arrayList = new ArrayList<ObservationHandler<Observation.Context>>(list.size());
            for (ObservationHandler<? extends Observation.Context> observationHandler : list) {
                arrayList.add(observationHandler);
            }
            this.handlers = arrayList;
        }

        @Override
        public List<ObservationHandler<Observation.Context>> getHandlers() {
            return this.handlers;
        }

        @Override
        public void onStart(Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                observationHandler.onStart(context);
            }
        }

        @Override
        public void onError(Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                observationHandler.onError(context);
            }
        }

        @Override
        public void onEvent(Observation.Event event, Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                observationHandler.onEvent(event, context);
            }
        }

        @Override
        public void onScopeOpened(Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                observationHandler.onScopeOpened(context);
            }
        }

        @Override
        public void onScopeClosed(Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                observationHandler.onScopeClosed(context);
            }
        }

        @Override
        public void onScopeReset(Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                observationHandler.onScopeReset(context);
            }
        }

        @Override
        public void onStop(Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                observationHandler.onStop(context);
            }
        }

        @Override
        public boolean supportsContext(Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                return true;
            }
            return false;
        }
    }

    public static class FirstMatchingCompositeObservationHandler
    implements CompositeObservationHandler {
        private final List<ObservationHandler<Observation.Context>> handlers;

        @SafeVarargs
        public FirstMatchingCompositeObservationHandler(ObservationHandler<? extends Observation.Context> ... observationHandlerArray) {
            this(Arrays.asList(observationHandlerArray));
        }

        public FirstMatchingCompositeObservationHandler(List<? extends ObservationHandler<? extends Observation.Context>> list) {
            ArrayList<ObservationHandler<Observation.Context>> arrayList = new ArrayList<ObservationHandler<Observation.Context>>(list.size());
            for (ObservationHandler<? extends Observation.Context> observationHandler : list) {
                arrayList.add(observationHandler);
            }
            this.handlers = arrayList;
        }

        @Override
        public List<ObservationHandler<Observation.Context>> getHandlers() {
            return this.handlers;
        }

        @Override
        public void onStart(Observation.Context context) {
            ObservationHandler<Observation.Context> observationHandler = this.getFirstApplicableHandler(context);
            if (observationHandler != null) {
                observationHandler.onStart(context);
            }
        }

        @Override
        public void onError(Observation.Context context) {
            ObservationHandler<Observation.Context> observationHandler = this.getFirstApplicableHandler(context);
            if (observationHandler != null) {
                observationHandler.onError(context);
            }
        }

        @Override
        public void onEvent(Observation.Event event, Observation.Context context) {
            ObservationHandler<Observation.Context> observationHandler = this.getFirstApplicableHandler(context);
            if (observationHandler != null) {
                observationHandler.onEvent(event, context);
            }
        }

        @Override
        public void onScopeOpened(Observation.Context context) {
            ObservationHandler<Observation.Context> observationHandler = this.getFirstApplicableHandler(context);
            if (observationHandler != null) {
                observationHandler.onScopeOpened(context);
            }
        }

        @Override
        public void onScopeClosed(Observation.Context context) {
            ObservationHandler<Observation.Context> observationHandler = this.getFirstApplicableHandler(context);
            if (observationHandler != null) {
                observationHandler.onScopeClosed(context);
            }
        }

        @Override
        public void onScopeReset(Observation.Context context) {
            ObservationHandler<Observation.Context> observationHandler = this.getFirstApplicableHandler(context);
            if (observationHandler != null) {
                observationHandler.onScopeReset(context);
            }
        }

        @Override
        public void onStop(Observation.Context context) {
            ObservationHandler<Observation.Context> observationHandler = this.getFirstApplicableHandler(context);
            if (observationHandler != null) {
                observationHandler.onStop(context);
            }
        }

        @Override
        public boolean supportsContext(Observation.Context context) {
            ObservationHandler<Observation.Context> observationHandler = this.getFirstApplicableHandler(context);
            return observationHandler != null;
        }

        @Nullable
        private ObservationHandler<Observation.Context> getFirstApplicableHandler(Observation.Context context) {
            for (ObservationHandler<Observation.Context> observationHandler : this.handlers) {
                if (!observationHandler.supportsContext(context)) continue;
                return observationHandler;
            }
            return null;
        }
    }

    public static interface CompositeObservationHandler
    extends ObservationHandler<Observation.Context> {
        public List<ObservationHandler<Observation.Context>> getHandlers();
    }
}

