/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.observation.aop;

import com.contrastsecurity.thirdparty.io.micrometer.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import com.contrastsecurity.thirdparty.io.micrometer.observation.annotation.Observed;
import com.contrastsecurity.thirdparty.io.micrometer.observation.aop.ObservedAspectObservationDocumentation;
import java.lang.reflect.Method;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
@NonNullApi
public class ObservedAspect {
    private static final Predicate<ProceedingJoinPoint> DONT_SKIP_ANYTHING = proceedingJoinPoint -> false;
    private final ObservationRegistry registry;
    @Nullable
    private final ObservationConvention<ObservedAspectContext> observationConvention;
    private final Predicate<ProceedingJoinPoint> shouldSkip;

    public ObservedAspect(ObservationRegistry observationRegistry) {
        this(observationRegistry, null, DONT_SKIP_ANYTHING);
    }

    public ObservedAspect(ObservationRegistry observationRegistry, ObservationConvention<ObservedAspectContext> observationConvention) {
        this(observationRegistry, observationConvention, DONT_SKIP_ANYTHING);
    }

    public ObservedAspect(ObservationRegistry observationRegistry, Predicate<ProceedingJoinPoint> predicate) {
        this(observationRegistry, null, predicate);
    }

    public ObservedAspect(ObservationRegistry observationRegistry, @Nullable ObservationConvention<ObservedAspectContext> observationConvention, Predicate<ProceedingJoinPoint> predicate) {
        this.registry = observationRegistry;
        this.observationConvention = observationConvention;
        this.shouldSkip = predicate;
    }

    @Around(value="@within(io.micrometer.observation.annotation.Observed)")
    @Nullable
    public Object observeClass(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        if (this.shouldSkip.test(proceedingJoinPoint)) {
            return proceedingJoinPoint.proceed();
        }
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        Observed observed = this.getDeclaringClass(proceedingJoinPoint).getAnnotation(Observed.class);
        return this.observe(proceedingJoinPoint, method, observed);
    }

    @Around(value="execution (@io.micrometer.observation.annotation.Observed * *.*(..))")
    @Nullable
    public Object observeMethod(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        if (this.shouldSkip.test(proceedingJoinPoint)) {
            return proceedingJoinPoint.proceed();
        }
        Method method = this.getMethod(proceedingJoinPoint);
        Observed observed = method.getAnnotation(Observed.class);
        return this.observe(proceedingJoinPoint, method, observed);
    }

    private Object observe(ProceedingJoinPoint proceedingJoinPoint, Method method, Observed observed) throws Throwable {
        Observation observation = ObservedAspectObservationDocumentation.of(proceedingJoinPoint, observed, this.registry, this.observationConvention);
        if (CompletionStage.class.isAssignableFrom(method.getReturnType())) {
            observation.start();
            try (Observation.Scope scope = observation.openScope();){
                CompletionStage<Object> completionStage = ((CompletionStage)proceedingJoinPoint.proceed()).whenComplete((object, throwable) -> this.stopObservation(observation, scope, (Throwable)throwable));
                return completionStage;
            }
        }
        return observation.observeChecked(() -> proceedingJoinPoint.proceed());
    }

    private Class<?> getDeclaringClass(ProceedingJoinPoint proceedingJoinPoint) {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        Class<?> clazz = method.getDeclaringClass();
        if (!clazz.isAnnotationPresent(Observed.class)) {
            return proceedingJoinPoint.getTarget().getClass();
        }
        return clazz;
    }

    private Method getMethod(ProceedingJoinPoint proceedingJoinPoint) throws NoSuchMethodException {
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        if (method.getAnnotation(Observed.class) == null) {
            return proceedingJoinPoint.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        return method;
    }

    private void stopObservation(Observation observation, Observation.Scope scope, @Nullable Throwable throwable) {
        if (throwable != null) {
            observation.error(throwable);
        }
        scope.close();
        observation.stop();
    }

    public static class ObservedAspectContext
    extends Observation.Context {
        private final ProceedingJoinPoint proceedingJoinPoint;

        public ObservedAspectContext(ProceedingJoinPoint proceedingJoinPoint) {
            this.proceedingJoinPoint = proceedingJoinPoint;
        }

        public ProceedingJoinPoint getProceedingJoinPoint() {
            return this.proceedingJoinPoint;
        }
    }
}

