/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.micrometer.observation.docs;

import com.contrastsecurity.thirdparty.io.micrometer.common.docs.KeyName;
import com.contrastsecurity.thirdparty.io.micrometer.common.lang.Nullable;
import com.contrastsecurity.thirdparty.io.micrometer.observation.Observation;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationConvention;
import com.contrastsecurity.thirdparty.io.micrometer.observation.ObservationRegistry;
import java.util.Objects;
import java.util.function.Supplier;

public interface ObservationDocumentation {
    public static final KeyName[] EMPTY = new KeyName[0];
    public static final Observation.Event[] EMPTY_EVENT_NAMES = new Observation.Event[0];

    @Nullable
    default public String getName() {
        return null;
    }

    @Nullable
    default public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
        return null;
    }

    @Nullable
    default public String getContextualName() {
        return null;
    }

    default public KeyName[] getLowCardinalityKeyNames() {
        return EMPTY;
    }

    default public KeyName[] getHighCardinalityKeyNames() {
        return EMPTY;
    }

    default public Observation.Event[] getEvents() {
        return EMPTY_EVENT_NAMES;
    }

    default public String getPrefix() {
        return "";
    }

    default public Observation observation(ObservationRegistry observationRegistry) {
        return this.observation(observationRegistry, Observation.Context::new);
    }

    default public Observation observation(ObservationRegistry observationRegistry, Supplier<Observation.Context> supplier) {
        Observation observation = Observation.createNotStarted(this.getName(), supplier, observationRegistry);
        if (this.getContextualName() != null) {
            observation.contextualName(this.getContextualName());
        }
        return observation;
    }

    default public <T extends Observation.Context> Observation observation(@Nullable ObservationConvention<T> observationConvention, ObservationConvention<T> observationConvention2, Supplier<T> supplier, ObservationRegistry observationRegistry) {
        if (this.getDefaultConvention() == null) {
            throw new IllegalStateException("You've decided to use convention based naming yet this observation [" + this.getClass() + "] has not defined any default convention");
        }
        if (!this.getDefaultConvention().isAssignableFrom(Objects.requireNonNull(observationConvention2, "You have not provided a default convention in the Observation factory method").getClass())) {
            throw new IllegalArgumentException("Observation [" + this.getClass() + "] defined default convention to be of type [" + this.getDefaultConvention() + "] but you have provided an incompatible one of type [" + observationConvention2.getClass() + "]");
        }
        Observation observation = Observation.createNotStarted(observationConvention, observationConvention2, supplier, observationRegistry);
        if (this.getName() != null) {
            observation.getContext().setName(this.getName());
        }
        if (this.getContextualName() != null) {
            observation.contextualName(this.getContextualName());
        }
        return observation;
    }

    default public Observation start(ObservationRegistry observationRegistry) {
        return this.start(observationRegistry, Observation.Context::new);
    }

    default public Observation start(ObservationRegistry observationRegistry, Supplier<Observation.Context> supplier) {
        return this.observation(observationRegistry, supplier).start();
    }

    default public <T extends Observation.Context> Observation start(@Nullable ObservationConvention<T> observationConvention, ObservationConvention<T> observationConvention2, Supplier<T> supplier, ObservationRegistry observationRegistry) {
        return this.observation(observationConvention, observationConvention2, supplier, observationRegistry).start();
    }
}

