/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.propagation;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.BaggageBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.BaggageEntryMetadata;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.propagation.BaggageCodec;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.baggage.propagation.Element;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

class Parser {
    private final String baggageHeader;
    private final Element key = Element.createKeyElement();
    private final Element value = Element.createValueElement();
    private String meta;
    private State state;
    private int metaStart;
    private boolean skipToNext;

    public Parser(String string) {
        this.baggageHeader = string;
        this.reset(0);
    }

    void parseInto(BaggageBuilder baggageBuilder) {
        int n2 = this.baggageHeader.length();
        block18: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = this.baggageHeader.charAt(i2);
            if (this.skipToNext) {
                if (c2 != ',') continue;
                this.reset(i2 + 1);
                continue;
            }
            switch (c2) {
                case '=': {
                    if (this.state == State.KEY) {
                        if (this.key.tryTerminating(i2, this.baggageHeader)) {
                            this.setState(State.VALUE, i2 + 1);
                            continue block18;
                        }
                        this.skipToNext = true;
                        continue block18;
                    }
                    if (this.state != State.VALUE) continue block18;
                    this.skipToNext = !this.value.tryNextChar(c2, i2);
                    continue block18;
                }
                case ';': {
                    if (this.state != State.VALUE) continue block18;
                    this.skipToNext = !this.value.tryTerminating(i2, this.baggageHeader);
                    this.setState(State.META, i2 + 1);
                    continue block18;
                }
                case ',': {
                    switch (this.state) {
                        case VALUE: {
                            this.value.tryTerminating(i2, this.baggageHeader);
                            break;
                        }
                        case META: {
                            this.meta = this.baggageHeader.substring(this.metaStart, i2).trim();
                            break;
                        }
                    }
                    Parser.putBaggage(baggageBuilder, this.key.getValue(), this.value.getValue(), this.meta);
                    this.reset(i2 + 1);
                    continue block18;
                }
                default: {
                    switch (this.state) {
                        case KEY: {
                            this.skipToNext = !this.key.tryNextChar(c2, i2);
                            continue block18;
                        }
                        case VALUE: {
                            this.skipToNext = !this.value.tryNextChar(c2, i2);
                            continue block18;
                        }
                    }
                }
            }
        }
        switch (this.state) {
            case KEY: {
                break;
            }
            case META: {
                String string = this.baggageHeader.substring(this.metaStart).trim();
                Parser.putBaggage(baggageBuilder, this.key.getValue(), this.value.getValue(), string);
                break;
            }
            case VALUE: {
                if (this.skipToNext) break;
                this.value.tryTerminating(this.baggageHeader.length(), this.baggageHeader);
                Parser.putBaggage(baggageBuilder, this.key.getValue(), this.value.getValue(), null);
            }
        }
    }

    private static void putBaggage(BaggageBuilder baggageBuilder, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        BaggageEntryMetadata baggageEntryMetadata;
        String string4 = Parser.decodeValue(string2);
        BaggageEntryMetadata baggageEntryMetadata2 = baggageEntryMetadata = (string3 = Parser.decodeValue(string3)) != null ? BaggageEntryMetadata.create(string3) : BaggageEntryMetadata.empty();
        if (string != null && string4 != null) {
            baggageBuilder.put(string, string4, baggageEntryMetadata);
        }
    }

    @Nullable
    private static String decodeValue(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return BaggageCodec.decode(string, StandardCharsets.UTF_8);
    }

    private void reset(int n2) {
        this.skipToNext = false;
        this.state = State.KEY;
        this.key.reset(n2);
        this.value.reset(n2);
        this.meta = "";
        this.metaStart = 0;
    }

    private void setState(State state, int n2) {
        this.state = state;
        this.metaStart = n2;
    }

    private static enum State {
        KEY,
        VALUE,
        META;

    }
}

