/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.ReadOnlyArrayMap;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Utils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class ImmutableKeyValuePairs<K, V> {
    private final Object[] data;
    private int hashcode;

    protected ImmutableKeyValuePairs(Object[] objectArray) {
        this.data = objectArray;
    }

    protected ImmutableKeyValuePairs(Object[] objectArray, Comparator<?> comparator) {
        this(ImmutableKeyValuePairs.sortAndFilter(objectArray, comparator));
    }

    protected final List<Object> data() {
        return Arrays.asList(this.data);
    }

    public final int size() {
        return this.data.length / 2;
    }

    public final boolean isEmpty() {
        return this.data.length == 0;
    }

    public final Map<K, V> asMap() {
        return ReadOnlyArrayMap.wrap(this.data());
    }

    @Nullable
    public final V get(K k2) {
        if (k2 == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            if (!k2.equals(this.data[i2])) continue;
            return (V)this.data[i2 + 1];
        }
        return null;
    }

    public final void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        if (biConsumer == null) {
            return;
        }
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            biConsumer.accept(this.data[i2], this.data[i2 + 1]);
        }
    }

    private static Object[] sortAndFilter(Object[] objectArray, Comparator<?> comparator) {
        Utils.checkArgument(objectArray.length % 2 == 0, "You must provide an even number of key/value pair arguments.");
        if (objectArray.length == 0) {
            return objectArray;
        }
        ImmutableKeyValuePairs.mergeSort(objectArray, comparator);
        return ImmutableKeyValuePairs.dedupe(objectArray, comparator);
    }

    private static void mergeSort(Object[] objectArray, Comparator<?> comparator) {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        ImmutableKeyValuePairs.splitAndMerge(objectArray2, 0, objectArray.length, objectArray, comparator);
    }

    private static void splitAndMerge(Object[] objectArray, int n2, int n3, Object[] objectArray2, Comparator<?> comparator) {
        if (n3 - n2 <= 2) {
            return;
        }
        int n4 = (n3 + n2) / 4 * 2;
        ImmutableKeyValuePairs.splitAndMerge(objectArray2, n2, n4, objectArray, comparator);
        ImmutableKeyValuePairs.splitAndMerge(objectArray2, n4, n3, objectArray, comparator);
        ImmutableKeyValuePairs.merge(objectArray, n2, n4, n3, objectArray2, comparator);
    }

    private static <K> void merge(Object[] objectArray, int n2, int n3, int n4, Object[] objectArray2, Comparator<K> comparator) {
        int n5 = n2;
        int n6 = n3;
        for (int i2 = n2; i2 < n4; i2 += 2) {
            if (n5 < n3 - 1 && (n6 >= n4 - 1 || ImmutableKeyValuePairs.compareToNullSafe(objectArray[n5], objectArray[n6], comparator) <= 0)) {
                objectArray2[i2] = objectArray[n5];
                objectArray2[i2 + 1] = objectArray[n5 + 1];
                n5 += 2;
                continue;
            }
            objectArray2[i2] = objectArray[n6];
            objectArray2[i2 + 1] = objectArray[n6 + 1];
            n6 += 2;
        }
    }

    private static <K> int compareToNullSafe(@Nullable K k2, @Nullable K k3, Comparator<K> comparator) {
        if (k2 == null) {
            return k3 == null ? 0 : -1;
        }
        if (k3 == null) {
            return 1;
        }
        return comparator.compare(k2, k3);
    }

    private static <K> Object[] dedupe(Object[] objectArray, Comparator<K> comparator) {
        Object object = null;
        int n2 = 0;
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            Object object2 = objectArray[i2];
            Object object3 = objectArray[i2 + 1];
            if (object2 == null) continue;
            if (object != null && comparator.compare(object2, object) == 0) {
                n2 -= 2;
            }
            if (object3 == null) {
                object = null;
                continue;
            }
            object = object2;
            objectArray[n2++] = object2;
            objectArray[n2++] = object3;
        }
        if (objectArray.length != n2) {
            Object[] objectArray2 = new Object[n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            return objectArray2;
        }
        return objectArray;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImmutableKeyValuePairs)) {
            return false;
        }
        ImmutableKeyValuePairs immutableKeyValuePairs = (ImmutableKeyValuePairs)object;
        return Arrays.equals(this.data, immutableKeyValuePairs.data);
    }

    public int hashCode() {
        int n2 = this.hashcode;
        if (n2 == 0) {
            n2 = 1;
            n2 *= 1000003;
            this.hashcode = n2 ^= Arrays.hashCode(this.data);
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            Object object = this.data[i2 + 1];
            String string = object instanceof String ? '\"' + (String)object + '\"' : object.toString();
            stringBuilder.append(this.data[i2]).append("=").append(string).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

