/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeType;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class InternalAttributeKeyImpl<T>
implements AttributeKey<T> {
    private final AttributeType type;
    private final String key;
    private final int hashCode;
    @Nullable
    private byte[] keyUtf8;

    private InternalAttributeKeyImpl(AttributeType attributeType, String string) {
        if (attributeType == null) {
            throw new NullPointerException("Null type");
        }
        this.type = attributeType;
        if (string == null) {
            throw new NullPointerException("Null key");
        }
        this.key = string;
        this.hashCode = InternalAttributeKeyImpl.buildHashCode(attributeType, string);
    }

    public static <T> AttributeKey<T> create(@Nullable String string, AttributeType attributeType) {
        return new InternalAttributeKeyImpl<T>(attributeType, string != null ? string : "");
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public byte[] getKeyUtf8() {
        byte[] byArray = this.keyUtf8;
        if (byArray == null) {
            this.keyUtf8 = byArray = this.key.getBytes(StandardCharsets.UTF_8);
        }
        return byArray;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InternalAttributeKeyImpl) {
            InternalAttributeKeyImpl internalAttributeKeyImpl = (InternalAttributeKeyImpl)object;
            return this.type.equals((Object)internalAttributeKeyImpl.getType()) && this.key.equals(internalAttributeKeyImpl.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.key;
    }

    private int buildHashCode() {
        return InternalAttributeKeyImpl.buildHashCode(this.type, this.key);
    }

    private static int buildHashCode(AttributeType attributeType, String string) {
        int n2 = 1;
        n2 *= 1000003;
        n2 ^= attributeType.hashCode();
        n2 *= 1000003;
        return n2 ^= string.hashCode();
    }
}

