/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.trace;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.ApiUsageLogger;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.TemporaryBuffers;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TraceId {
    private static final int BYTES_LENGTH = 16;
    private static final int HEX_LENGTH = 32;
    private static final String INVALID = "00000000000000000000000000000000";

    private TraceId() {
    }

    public static int getLength() {
        return 32;
    }

    public static String getInvalid() {
        return INVALID;
    }

    public static boolean isValid(CharSequence charSequence) {
        return charSequence != null && charSequence.length() == 32 && !INVALID.contentEquals(charSequence) && OtelEncodingUtils.isValidBase16String(charSequence);
    }

    public static String fromBytes(byte[] byArray) {
        if (byArray == null || byArray.length < 16) {
            ApiUsageLogger.log("traceIdBytes is null or too short");
            return INVALID;
        }
        char[] cArray = TemporaryBuffers.chars(32);
        OtelEncodingUtils.bytesToBase16(byArray, cArray, 16);
        return new String(cArray, 0, 32);
    }

    public static String fromLongs(long l2, long l3) {
        if (l2 == 0L && l3 == 0L) {
            return TraceId.getInvalid();
        }
        char[] cArray = TemporaryBuffers.chars(32);
        OtelEncodingUtils.longToBase16String(l2, cArray, 0);
        OtelEncodingUtils.longToBase16String(l3, cArray, 16);
        return new String(cArray, 0, 32);
    }
}

