/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.propagation;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.TemporaryBuffers;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanId;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceFlags;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceId;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceState;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapGetter;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapPropagator;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class W3CTraceContextPropagator
implements TextMapPropagator {
    private static final f logger = f.a(W3CTraceContextPropagator.class.getName());
    static final String TRACE_PARENT = "traceparent";
    static final String TRACE_STATE = "tracestate";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("traceparent", "tracestate"));
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = TraceId.getLength();
    private static final int SPAN_ID_HEX_SIZE = SpanId.getLength();
    private static final int TRACE_OPTION_HEX_SIZE = TraceFlags.getLength();
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 3 + TRACE_ID_HEX_SIZE + 1;
    private static final int TRACE_OPTION_OFFSET = SPAN_ID_OFFSET + SPAN_ID_HEX_SIZE + 1;
    private static final int TRACEPARENT_HEADER_SIZE = TRACE_OPTION_OFFSET + TRACE_OPTION_HEX_SIZE;
    private static final Set<String> VALID_VERSIONS;
    private static final String VERSION_00 = "00";
    private static final W3CTraceContextPropagator INSTANCE;

    private W3CTraceContextPropagator() {
    }

    public static W3CTraceContextPropagator getInstance() {
        return INSTANCE;
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    @Override
    public <C> void inject(Context context, @Nullable C c2, TextMapSetter<C> textMapSetter) {
        if (context == null || textMapSetter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext(context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        char[] cArray = TemporaryBuffers.chars(TRACEPARENT_HEADER_SIZE);
        cArray[0] = "00".charAt(0);
        cArray[1] = "00".charAt(1);
        cArray[2] = 45;
        String string = spanContext.getTraceId();
        string.getChars(0, string.length(), cArray, 3);
        cArray[W3CTraceContextPropagator.SPAN_ID_OFFSET - 1] = 45;
        String string2 = spanContext.getSpanId();
        string2.getChars(0, string2.length(), cArray, SPAN_ID_OFFSET);
        cArray[W3CTraceContextPropagator.TRACE_OPTION_OFFSET - 1] = 45;
        String string3 = spanContext.getTraceFlags().asHex();
        cArray[W3CTraceContextPropagator.TRACE_OPTION_OFFSET] = string3.charAt(0);
        cArray[W3CTraceContextPropagator.TRACE_OPTION_OFFSET + 1] = string3.charAt(1);
        textMapSetter.set(c2, TRACE_PARENT, new String(cArray, 0, TRACEPARENT_HEADER_SIZE));
        TraceState traceState = spanContext.getTraceState();
        if (traceState.isEmpty()) {
            return;
        }
        textMapSetter.set(c2, TRACE_STATE, W3CTraceContextEncoding.encodeTraceState(traceState));
    }

    @Override
    public <C> Context extract(Context context, @Nullable C c2, TextMapGetter<C> textMapGetter) {
        if (context == null) {
            return Context.root();
        }
        if (textMapGetter == null) {
            return context;
        }
        SpanContext spanContext = W3CTraceContextPropagator.extractImpl(c2, textMapGetter);
        if (!spanContext.isValid()) {
            return context;
        }
        return context.with(Span.wrap(spanContext));
    }

    private static <C> SpanContext extractImpl(@Nullable C c2, TextMapGetter<C> textMapGetter) {
        String string = textMapGetter.get(c2, TRACE_PARENT);
        if (string == null) {
            return SpanContext.getInvalid();
        }
        SpanContext spanContext = W3CTraceContextPropagator.extractContextFromTraceParent(string);
        if (!spanContext.isValid()) {
            return spanContext;
        }
        String string2 = textMapGetter.get(c2, TRACE_STATE);
        if (string2 == null || string2.isEmpty()) {
            return spanContext;
        }
        try {
            TraceState traceState = W3CTraceContextEncoding.decodeTraceState(string2);
            return SpanContext.createFromRemoteParent(spanContext.getTraceId(), spanContext.getSpanId(), spanContext.getTraceFlags(), traceState);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.f("Unparseable tracestate header. Returning span context without state.");
            return spanContext;
        }
    }

    private static SpanContext extractContextFromTraceParent(String string) {
        boolean bl2;
        boolean bl3 = bl2 = (string.length() == TRACEPARENT_HEADER_SIZE || string.length() > TRACEPARENT_HEADER_SIZE && string.charAt(TRACEPARENT_HEADER_SIZE) == '-') && string.charAt(2) == '-' && string.charAt(SPAN_ID_OFFSET - 1) == '-' && string.charAt(TRACE_OPTION_OFFSET - 1) == '-';
        if (!bl2) {
            logger.f("Unparseable traceparent header. Returning INVALID span context.");
            return SpanContext.getInvalid();
        }
        String string2 = string.substring(0, 2);
        if (!VALID_VERSIONS.contains(string2)) {
            return SpanContext.getInvalid();
        }
        if (string2.equals("00") && string.length() > TRACEPARENT_HEADER_SIZE) {
            return SpanContext.getInvalid();
        }
        String string3 = string.substring(3, 3 + TraceId.getLength());
        String string4 = string.substring(SPAN_ID_OFFSET, SPAN_ID_OFFSET + SpanId.getLength());
        char c2 = string.charAt(TRACE_OPTION_OFFSET);
        char c3 = string.charAt(TRACE_OPTION_OFFSET + 1);
        if (!OtelEncodingUtils.isValidBase16Character(c2) || !OtelEncodingUtils.isValidBase16Character(c3)) {
            return SpanContext.getInvalid();
        }
        TraceFlags traceFlags = TraceFlags.fromByte(OtelEncodingUtils.byteFromBase16(c2, c3));
        return SpanContext.createFromRemoteParent(string3, string4, traceFlags, TraceState.getDefault());
    }

    public String toString() {
        return "W3CTraceContextPropagator";
    }

    static {
        INSTANCE = new W3CTraceContextPropagator();
        VALID_VERSIONS = new HashSet<String>();
        for (int i2 = 0; i2 < 255; ++i2) {
            String string = Long.toHexString(i2);
            if (string.length() < 2) {
                string = '0' + string;
            }
            VALID_VERSIONS.add(string);
        }
    }
}

