/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.context;

import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ContextKey;
import java.util.Arrays;
import javax.annotation.Nullable;

final class ArrayBasedContext
implements Context {
    private static final Context ROOT = new ArrayBasedContext(new Object[0]);
    private final Object[] entries;

    static Context root() {
        return ROOT;
    }

    private ArrayBasedContext(Object[] objectArray) {
        this.entries = objectArray;
    }

    @Override
    @Nullable
    public <V> V get(ContextKey<V> contextKey) {
        for (int i2 = 0; i2 < this.entries.length; i2 += 2) {
            if (this.entries[i2] != contextKey) continue;
            Object object = this.entries[i2 + 1];
            return (V)object;
        }
        return null;
    }

    @Override
    public <V> Context with(ContextKey<V> contextKey, V v2) {
        for (int i2 = 0; i2 < this.entries.length; i2 += 2) {
            if (this.entries[i2] != contextKey) continue;
            if (this.entries[i2 + 1] == v2) {
                return this;
            }
            Object[] objectArray = (Object[])this.entries.clone();
            objectArray[i2 + 1] = v2;
            return new ArrayBasedContext(objectArray);
        }
        Object[] objectArray = Arrays.copyOf(this.entries, this.entries.length + 2);
        objectArray[objectArray.length - 2] = contextKey;
        objectArray[objectArray.length - 1] = v2;
        return new ArrayBasedContext(objectArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (int i2 = 0; i2 < this.entries.length; i2 += 2) {
            stringBuilder.append(this.entries[i2]).append('=').append(this.entries[i2 + 1]).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

