/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.context;

import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.ForwardingExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ContextExecutorService
extends ForwardingExecutorService {
    private final Context context;

    ContextExecutorService(Context context, ExecutorService executorService) {
        super(executorService);
        this.context = context;
    }

    final Context context() {
        return this.context;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegate().submit(this.context.wrap(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t2) {
        return this.delegate().submit(this.context.wrap(runnable), t2);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate().submit(this.context.wrap(runnable));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.delegate().invokeAll(ContextExecutorService.wrap(this.context, collection));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate().invokeAll(ContextExecutorService.wrap(this.context, collection), l2, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.delegate().invokeAny(ContextExecutorService.wrap(this.context, collection));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate().invokeAny(ContextExecutorService.wrap(this.context, collection), l2, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate().execute(this.context.wrap(runnable));
    }
}

