/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation;

import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapGetter;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapPropagator;
import com.contrastsecurity.thirdparty.io.opentelemetry.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

final class MultiTextMapPropagator
implements TextMapPropagator {
    private final TextMapPropagator[] textMapPropagators;
    private final Collection<String> allFields;

    MultiTextMapPropagator(TextMapPropagator ... textMapPropagatorArray) {
        this(Arrays.asList(textMapPropagatorArray));
    }

    MultiTextMapPropagator(List<TextMapPropagator> list) {
        this.textMapPropagators = new TextMapPropagator[list.size()];
        list.toArray(this.textMapPropagators);
        this.allFields = Collections.unmodifiableList(MultiTextMapPropagator.getAllFields(this.textMapPropagators));
    }

    @Override
    public Collection<String> fields() {
        return this.allFields;
    }

    private static List<String> getAllFields(TextMapPropagator[] textMapPropagatorArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (TextMapPropagator textMapPropagator : textMapPropagatorArray) {
            linkedHashSet.addAll(textMapPropagator.fields());
        }
        return new ArrayList<String>(linkedHashSet);
    }

    @Override
    public <C> void inject(Context context, @Nullable C c2, TextMapSetter<C> textMapSetter) {
        if (context == null || textMapSetter == null) {
            return;
        }
        for (TextMapPropagator textMapPropagator : this.textMapPropagators) {
            textMapPropagator.inject(context, c2, textMapSetter);
        }
    }

    @Override
    public <C> Context extract(Context context, @Nullable C c2, TextMapGetter<C> textMapGetter) {
        if (context == null) {
            return Context.root();
        }
        if (textMapGetter == null) {
            return context;
        }
        for (TextMapPropagator textMapPropagator : this.textMapPropagators) {
            context = textMapPropagator.extract(context, c2, textMapGetter);
        }
        return context;
    }

    public String toString() {
        return "MultiTextMapPropagator{textMapPropagators=" + Arrays.toString(this.textMapPropagators) + '}';
    }
}

