/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.LongCounter;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.Meter;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class ExporterMetrics {
    private static final AttributeKey<String> ATTRIBUTE_KEY_TYPE = AttributeKey.stringKey("type");
    private static final AttributeKey<Boolean> ATTRIBUTE_KEY_SUCCESS = AttributeKey.booleanKey("success");
    private final Supplier<MeterProvider> meterProviderSupplier;
    private final String exporterName;
    private final String transportName;
    private final Attributes seenAttrs;
    private final Attributes successAttrs;
    private final Attributes failedAttrs;
    @Nullable
    private volatile LongCounter seen;
    @Nullable
    private volatile LongCounter exported;

    private ExporterMetrics(Supplier<MeterProvider> supplier, String string, String string2, String string3) {
        this.meterProviderSupplier = supplier;
        this.exporterName = string;
        this.transportName = string3;
        this.seenAttrs = Attributes.builder().put(ATTRIBUTE_KEY_TYPE, string2).build();
        this.successAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(true)).build();
        this.failedAttrs = this.seenAttrs.toBuilder().put(ATTRIBUTE_KEY_SUCCESS, Boolean.valueOf(false)).build();
    }

    public void addSeen(long l2) {
        this.seen().add(l2, this.seenAttrs);
    }

    public void addSuccess(long l2) {
        this.exported().add(l2, this.successAttrs);
    }

    public void addFailed(long l2) {
        this.exported().add(l2, this.failedAttrs);
    }

    private LongCounter seen() {
        LongCounter longCounter = this.seen;
        if (longCounter == null) {
            this.seen = longCounter = this.meter().counterBuilder(this.exporterName + ".exporter.seen").build();
        }
        return longCounter;
    }

    private LongCounter exported() {
        LongCounter longCounter = this.exported;
        if (longCounter == null) {
            this.exported = longCounter = this.meter().counterBuilder(this.exporterName + ".exporter.exported").build();
        }
        return longCounter;
    }

    private Meter meter() {
        return this.meterProviderSupplier.get().get("com.contrastsecurity.thirdparty.io.opentelemetry.exporters." + this.exporterName + "-" + this.transportName);
    }

    public static ExporterMetrics createGrpc(String string, String string2, Supplier<MeterProvider> supplier) {
        return new ExporterMetrics(supplier, string, string2, "grpc");
    }

    public static ExporterMetrics createGrpcOkHttp(String string, String string2, Supplier<MeterProvider> supplier) {
        return new ExporterMetrics(supplier, string, string2, "grpc-okhttp");
    }

    public static ExporterMetrics createHttpProtobuf(String string, String string2, Supplier<MeterProvider> supplier) {
        return new ExporterMetrics(supplier, string, string2, "http");
    }

    public static ExporterMetrics createHttpJson(String string, String string2, Supplier<MeterProvider> supplier) {
        return new ExporterMetrics(supplier, string, string2, "http-json");
    }
}

