/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.GlobalOpenTelemetry;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.ConfigUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.TlsConfigHelper;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcSender;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.export.RetryPolicy;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public class GrpcExporterBuilder<T extends Marshaler> {
    private static final f LOGGER = f.a(GrpcExporterBuilder.class.getName());
    private final String exporterName;
    private final String type;
    private final String grpcEndpointPath;
    private final Supplier<BiFunction<Channel, String, MarshalerServiceStub<T, ?, ?>>> grpcStubFactory;
    private long timeoutNanos;
    private URI endpoint;
    private boolean compressionEnabled = false;
    private final Map<String, String> headers = new HashMap<String, String>();
    private TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
    @Nullable
    private RetryPolicy retryPolicy;
    private Supplier<MeterProvider> meterProviderSupplier = GlobalOpenTelemetry::getMeterProvider;
    @Nullable
    private Object grpcChannel;

    public GrpcExporterBuilder(String string, String string2, long l2, URI uRI, Supplier<BiFunction<Channel, String, MarshalerServiceStub<T, ?, ?>>> supplier, String string3) {
        this.exporterName = string;
        this.type = string2;
        this.grpcEndpointPath = string3;
        this.timeoutNanos = TimeUnit.SECONDS.toNanos(l2);
        this.endpoint = uRI;
        this.grpcStubFactory = supplier;
    }

    public GrpcExporterBuilder<T> setChannel(ManagedChannel managedChannel) {
        this.grpcChannel = managedChannel;
        return this;
    }

    public GrpcExporterBuilder<T> setTimeout(long l2, TimeUnit timeUnit) {
        this.timeoutNanos = timeUnit.toNanos(l2);
        return this;
    }

    public GrpcExporterBuilder<T> setTimeout(Duration duration) {
        return this.setTimeout(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public GrpcExporterBuilder<T> setEndpoint(String string) {
        this.endpoint = ExporterBuilderUtil.validateEndpoint(string);
        return this;
    }

    public GrpcExporterBuilder<T> setCompression(String string) {
        this.compressionEnabled = string.equals("gzip");
        return this;
    }

    public GrpcExporterBuilder<T> setTrustManagerFromCerts(byte[] byArray) {
        this.tlsConfigHelper.setTrustManagerFromCerts(byArray);
        return this;
    }

    public GrpcExporterBuilder<T> setKeyManagerFromCerts(byte[] byArray, byte[] byArray2) {
        this.tlsConfigHelper.setKeyManagerFromCerts(byArray, byArray2);
        return this;
    }

    public GrpcExporterBuilder<T> setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        this.tlsConfigHelper.setSslContext(sSLContext, x509TrustManager);
        return this;
    }

    public GrpcExporterBuilder<T> addHeader(String string, String string2) {
        this.headers.put(string, string2);
        return this;
    }

    public GrpcExporterBuilder<T> setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public GrpcExporterBuilder<T> setMeterProvider(MeterProvider meterProvider) {
        this.meterProviderSupplier = () -> meterProvider;
        return this;
    }

    public GrpcExporterBuilder<T> copy() {
        GrpcExporterBuilder<T> grpcExporterBuilder = new GrpcExporterBuilder<T>(this.exporterName, this.type, TimeUnit.NANOSECONDS.toSeconds(this.timeoutNanos), this.endpoint, this.grpcStubFactory, this.grpcEndpointPath);
        grpcExporterBuilder.timeoutNanos = this.timeoutNanos;
        grpcExporterBuilder.endpoint = this.endpoint;
        grpcExporterBuilder.compressionEnabled = this.compressionEnabled;
        grpcExporterBuilder.headers.putAll(this.headers);
        grpcExporterBuilder.tlsConfigHelper = this.tlsConfigHelper.copy();
        if (this.retryPolicy != null) {
            grpcExporterBuilder.retryPolicy = this.retryPolicy.toBuilder().build();
        }
        grpcExporterBuilder.meterProviderSupplier = this.meterProviderSupplier;
        grpcExporterBuilder.grpcChannel = this.grpcChannel;
        return grpcExporterBuilder;
    }

    public GrpcExporter<T> build() {
        GrpcSenderProvider grpcSenderProvider = GrpcExporterBuilder.resolveGrpcSenderProvider();
        GrpcSender<T> grpcSender = grpcSenderProvider.createSender(this.endpoint, this.grpcEndpointPath, this.compressionEnabled, this.timeoutNanos, this.headers, this.grpcChannel, this.grpcStubFactory, this.retryPolicy, this.tlsConfigHelper.getSslContext(), this.tlsConfigHelper.getTrustManager());
        LOGGER.a(f.a.f, "Using GrpcSender: " + grpcSender.getClass().getName());
        return new GrpcExporter<T>(this.exporterName, this.type, grpcSender, this.meterProviderSupplier);
    }

    public String toString(boolean bl2) {
        StringJoiner stringJoiner = bl2 ? new StringJoiner(", ", "GrpcExporterBuilder{", "}") : new StringJoiner(", ");
        stringJoiner.add("exporterName=" + this.exporterName);
        stringJoiner.add("type=" + this.type);
        stringJoiner.add("endpoint=" + this.endpoint.toString());
        stringJoiner.add("endpointPath=" + this.grpcEndpointPath);
        stringJoiner.add("timeoutNanos=" + this.timeoutNanos);
        stringJoiner.add("compressionEnabled=" + this.compressionEnabled);
        StringJoiner stringJoiner2 = new StringJoiner(", ", "Headers{", "}");
        this.headers.forEach((string, string2) -> stringJoiner2.add(string + "=OBFUSCATED"));
        stringJoiner.add("headers=" + stringJoiner2);
        if (this.retryPolicy != null) {
            stringJoiner.add("retryPolicy=" + this.retryPolicy);
        }
        if (this.grpcChannel != null) {
            stringJoiner.add("grpcChannel=" + this.grpcChannel);
        }
        return stringJoiner.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    private static GrpcSenderProvider resolveGrpcSenderProvider() {
        HashMap<String, GrpcSenderProvider> hashMap = new HashMap<String, GrpcSenderProvider>();
        for (GrpcSenderProvider grpcSenderProvider : ServiceLoader.load(GrpcSenderProvider.class, GrpcExporterBuilder.class.getClassLoader())) {
            hashMap.put(grpcSenderProvider.getClass().getName(), grpcSenderProvider);
        }
        if (hashMap.isEmpty()) {
            throw new IllegalStateException("No GrpcSenderProvider found on classpath. Please add dependency on opentelemetry-exporter-sender-okhttp or opentelemetry-exporter-sender-grpc-upstream");
        }
        if (hashMap.size() == 1) {
            return (GrpcSenderProvider)hashMap.values().stream().findFirst().get();
        }
        String string = ConfigUtil.getString("com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider", "");
        if (string.isEmpty()) {
            LOGGER.a(f.a.c, "Multiple GrpcSenderProvider found. Please include only one, or specify preference setting io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider to the FQCN of the preferred provider.");
            return (GrpcSenderProvider)hashMap.values().stream().findFirst().get();
        }
        if (hashMap.containsKey(string)) {
            return (GrpcSenderProvider)hashMap.get(string);
        }
        throw new IllegalStateException("No GrpcSenderProvider matched configured io.opentelemetry.exporter.internal.grpc.GrpcSenderProvider: " + (String)string);
    }
}

