/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc;

import com.contrastsecurity.agent.logging.log4j2.f;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.CodedInputStream;
import java.io.IOException;
import javax.annotation.Nullable;

public final class GrpcExporterUtil {
    public static final int GRPC_STATUS_CANCELLED = 1;
    public static final int GRPC_STATUS_UNKNOWN = 2;
    public static final int GRPC_STATUS_DEADLINE_EXCEEDED = 4;
    public static final int GRPC_STATUS_RESOURCE_EXHAUSTED = 8;
    public static final int GRPC_STATUS_ABORTED = 10;
    public static final int GRPC_STATUS_OUT_OF_RANGE = 11;
    public static final int GRPC_STATUS_UNIMPLEMENTED = 12;
    public static final int GRPC_STATUS_UNAVAILABLE = 14;
    public static final int GRPC_STATUS_DATA_LOSS = 15;

    static void logUnimplemented(f f2, String string, @Nullable String string2) {
        String string3;
        switch (string) {
            case "span": {
                string3 = "OTEL_TRACES_EXPORTER";
                break;
            }
            case "metric": {
                string3 = "OTEL_METRICS_EXPORTER";
                break;
            }
            case "log": {
                string3 = "OTEL_LOGS_EXPORTER";
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized type, this is a programming bug in the OpenTelemetry SDK");
            }
        }
        f2.a(f.a.b, "Failed to export " + string + "s. Server responded with UNIMPLEMENTED. This usually means that your collector is not configured with an otlp receiver in the \"pipelines\" section of the configuration. If export is not desired and you are using OpenTelemetry autoconfiguration or the javaagent, disable export by setting " + string3 + "=none. Full error message: " + string2);
    }

    private GrpcExporterUtil() {
    }

    public static String getStatusMessage(byte[] byArray) throws IOException {
        CodedInputStream codedInputStream = CodedInputStream.newInstance(byArray);
        boolean bl2 = false;
        block4: while (!bl2) {
            int n2 = codedInputStream.readTag();
            switch (n2) {
                case 0: {
                    bl2 = true;
                    continue block4;
                }
                case 18: {
                    return codedInputStream.readStringRequireUtf8();
                }
            }
            codedInputStream.skipField(n2);
        }
        return "";
    }
}

