/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc;

import com.contrastsecurity.thirdparty.com.google.common.io.ByteStreams;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.grpc.Drainable;
import io.grpc.KnownLength;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;

public final class MarshalerInputStream
extends InputStream
implements Drainable,
KnownLength {
    @Nullable
    private Marshaler message;
    @Nullable
    private ByteArrayInputStream partial;

    public MarshalerInputStream(Marshaler marshaler) {
        this.message = marshaler;
    }

    public int drainTo(OutputStream outputStream) throws IOException {
        int n2;
        if (this.message != null) {
            n2 = this.message.getBinarySerializedSize();
            this.message.writeBinaryTo(outputStream);
            this.message = null;
        } else if (this.partial != null) {
            n2 = (int)ByteStreams.copy((InputStream)this.partial, (OutputStream)outputStream);
            this.partial = null;
        } else {
            n2 = 0;
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        if (this.message != null) {
            this.partial = new ByteArrayInputStream(MarshalerInputStream.toByteArray(this.message));
            this.message = null;
        }
        if (this.partial != null) {
            return this.partial.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.message != null) {
            int n4 = this.message.getBinarySerializedSize();
            if (n4 == 0) {
                this.message = null;
                this.partial = null;
                return -1;
            }
            this.partial = new ByteArrayInputStream(MarshalerInputStream.toByteArray(this.message));
            this.message = null;
        }
        if (this.partial != null) {
            return this.partial.read(byArray, n2, n3);
        }
        return -1;
    }

    private static byte[] toByteArray(Marshaler marshaler) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(marshaler.getBinarySerializedSize());
        marshaler.writeBinaryTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public int available() {
        if (this.message != null) {
            return this.message.getBinarySerializedSize();
        }
        if (this.partial != null) {
            return this.partial.available();
        }
        return 0;
    }
}

