/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.OtelEncodingUtils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanId;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceId;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.CodedOutputStream;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ProtoSerializer
extends Serializer
implements AutoCloseable {
    private static final ThreadLocal<Map<String, byte[]>> THREAD_LOCAL_ID_CACHE = new ThreadLocal();
    private final CodedOutputStream output;
    private final Map<String, byte[]> idCache;

    ProtoSerializer(OutputStream outputStream) {
        this.output = CodedOutputStream.newInstance(outputStream);
        this.idCache = ProtoSerializer.getIdCache();
    }

    @Override
    protected void writeTraceId(ProtoFieldInfo protoFieldInfo, String string2) throws IOException {
        byte[] byArray = this.idCache.computeIfAbsent(string2, string -> OtelEncodingUtils.bytesFromBase16(string, TraceId.getLength()));
        this.writeBytes(protoFieldInfo, byArray);
    }

    @Override
    protected void writeSpanId(ProtoFieldInfo protoFieldInfo, String string2) throws IOException {
        byte[] byArray = this.idCache.computeIfAbsent(string2, string -> OtelEncodingUtils.bytesFromBase16(string, SpanId.getLength()));
        this.writeBytes(protoFieldInfo, byArray);
    }

    @Override
    public void writeBool(ProtoFieldInfo protoFieldInfo, boolean bl2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeBoolNoTag(bl2);
    }

    @Override
    protected void writeEnum(ProtoFieldInfo protoFieldInfo, ProtoEnumInfo protoEnumInfo) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeEnumNoTag(protoEnumInfo.getEnumNumber());
    }

    @Override
    protected void writeUint32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeUInt32NoTag(n2);
    }

    @Override
    protected void writeSInt32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeSInt32NoTag(n2);
    }

    @Override
    protected void writeint32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeInt32NoTag(n2);
    }

    @Override
    public void writeInt64(ProtoFieldInfo protoFieldInfo, long l2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeInt64NoTag(l2);
    }

    @Override
    protected void writeFixed64(ProtoFieldInfo protoFieldInfo, long l2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeFixed64NoTag(l2);
    }

    @Override
    protected void writeFixed64Value(long l2) throws IOException {
        this.output.writeFixed64NoTag(l2);
    }

    @Override
    protected void writeUInt64Value(long l2) throws IOException {
        this.output.writeUInt64NoTag(l2);
    }

    @Override
    protected void writeFixed32(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeFixed32NoTag(n2);
    }

    @Override
    public void writeDouble(ProtoFieldInfo protoFieldInfo, double d2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeDoubleNoTag(d2);
    }

    @Override
    protected void writeDoubleValue(double d2) throws IOException {
        this.output.writeDoubleNoTag(d2);
    }

    @Override
    public void writeString(ProtoFieldInfo protoFieldInfo, byte[] byArray) throws IOException {
        this.writeBytes(protoFieldInfo, byArray);
    }

    @Override
    protected void writeBytes(ProtoFieldInfo protoFieldInfo, byte[] byArray) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeByteArrayNoTag(byArray);
    }

    @Override
    protected void writeStartMessage(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeUInt32NoTag(n2);
    }

    @Override
    protected void writeEndMessage() {
    }

    @Override
    protected void writeStartRepeatedPrimitive(ProtoFieldInfo protoFieldInfo, int n2, int n3) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeUInt32NoTag(n2 * n3);
    }

    @Override
    protected void writeEndRepeatedPrimitive() {
    }

    @Override
    protected void writeStartRepeatedVarint(ProtoFieldInfo protoFieldInfo, int n2) throws IOException {
        this.output.writeUInt32NoTag(protoFieldInfo.getTag());
        this.output.writeUInt32NoTag(n2);
    }

    @Override
    protected void writeEndRepeatedVarint() {
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo protoFieldInfo, Marshaler[] marshalerArray) throws IOException {
        for (Marshaler marshaler : marshalerArray) {
            this.serializeMessage(protoFieldInfo, marshaler);
        }
    }

    @Override
    public void serializeRepeatedMessage(ProtoFieldInfo protoFieldInfo, List<? extends Marshaler> list) throws IOException {
        for (Marshaler marshaler : list) {
            this.serializeMessage(protoFieldInfo, marshaler);
        }
    }

    @Override
    public void writeSerializedMessage(byte[] byArray, String string) throws IOException {
        this.output.writeRawBytes(byArray);
    }

    @Override
    public void close() throws IOException {
        try {
            this.output.flush();
            this.idCache.clear();
        }
        catch (IOException iOException) {
            throw new IOException(iOException);
        }
    }

    private static Map<String, byte[]> getIdCache() {
        Map<String, byte[]> map = THREAD_LOCAL_ID_CACHE.get();
        if (map == null) {
            map = new HashMap<String, byte[]>();
            THREAD_LOCAL_ID_CACHE.set(map);
        }
        return map;
    }
}

