/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp;

import com.contrastsecurity.thirdparty.io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.common.v1.internal.InstrumentationScope;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class InstrumentationScopeMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<InstrumentationScopeInfo, InstrumentationScopeMarshaler> SCOPE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction<InstrumentationScopeInfo, InstrumentationScopeMarshaler>();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static InstrumentationScopeMarshaler create(InstrumentationScopeInfo instrumentationScopeInfo) {
        InstrumentationScopeMarshaler instrumentationScopeMarshaler = (InstrumentationScopeMarshaler)SCOPE_MARSHALER_CACHE.get((Object)instrumentationScopeInfo);
        if (instrumentationScopeMarshaler == null) {
            byte[] byArray = MarshalerUtil.toBytes(instrumentationScopeInfo.getName());
            byte[] byArray2 = MarshalerUtil.toBytes(instrumentationScopeInfo.getVersion());
            KeyValueMarshaler[] keyValueMarshalerArray = KeyValueMarshaler.createRepeated(instrumentationScopeInfo.getAttributes());
            RealInstrumentationScopeMarshaler realInstrumentationScopeMarshaler = new RealInstrumentationScopeMarshaler(byArray, byArray2, keyValueMarshalerArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(realInstrumentationScopeMarshaler.getBinarySerializedSize());
            try {
                realInstrumentationScopeMarshaler.writeBinaryTo(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", iOException);
            }
            String string = MarshalerUtil.preserializeJsonFields(realInstrumentationScopeMarshaler);
            instrumentationScopeMarshaler = new InstrumentationScopeMarshaler(byteArrayOutputStream.toByteArray(), string);
            SCOPE_MARSHALER_CACHE.put((Object)instrumentationScopeInfo, (Object)instrumentationScopeMarshaler);
        }
        return instrumentationScopeMarshaler;
    }

    private InstrumentationScopeMarshaler(byte[] byArray, String string) {
        super(byArray.length);
        this.serializedBinary = byArray;
        this.serializedJson = string;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealInstrumentationScopeMarshaler
    extends MarshalerWithSize {
        private final byte[] name;
        private final byte[] version;
        private final KeyValueMarshaler[] attributes;

        RealInstrumentationScopeMarshaler(byte[] byArray, byte[] byArray2, KeyValueMarshaler[] keyValueMarshalerArray) {
            super(RealInstrumentationScopeMarshaler.computeSize(byArray, byArray2, keyValueMarshalerArray));
            this.name = byArray;
            this.version = byArray2;
            this.attributes = keyValueMarshalerArray;
        }

        @Override
        protected void writeTo(Serializer serializer) throws IOException {
            serializer.serializeString(InstrumentationScope.NAME, this.name);
            serializer.serializeString(InstrumentationScope.VERSION, this.version);
            serializer.serializeRepeatedMessage(InstrumentationScope.ATTRIBUTES, this.attributes);
        }

        private static int computeSize(byte[] byArray, byte[] byArray2, KeyValueMarshaler[] keyValueMarshalerArray) {
            return MarshalerUtil.sizeBytes(InstrumentationScope.NAME, byArray) + MarshalerUtil.sizeBytes(InstrumentationScope.VERSION, byArray2) + MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)InstrumentationScope.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
        }
    }
}

