/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp;

import com.contrastsecurity.thirdparty.io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.resource.v1.internal.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class ResourceMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource, ResourceMarshaler> RESOURCE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction<com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource, ResourceMarshaler>();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static ResourceMarshaler create(com.contrastsecurity.thirdparty.io.opentelemetry.sdk.resources.Resource resource) {
        ResourceMarshaler resourceMarshaler = (ResourceMarshaler)RESOURCE_MARSHALER_CACHE.get((Object)resource);
        if (resourceMarshaler == null) {
            RealResourceMarshaler realResourceMarshaler = new RealResourceMarshaler(KeyValueMarshaler.createRepeated(resource.getAttributes()));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(realResourceMarshaler.getBinarySerializedSize());
            try {
                realResourceMarshaler.writeBinaryTo(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", iOException);
            }
            String string = MarshalerUtil.preserializeJsonFields(realResourceMarshaler);
            resourceMarshaler = new ResourceMarshaler(byteArrayOutputStream.toByteArray(), string);
            RESOURCE_MARSHALER_CACHE.put((Object)resource, (Object)resourceMarshaler);
        }
        return resourceMarshaler;
    }

    private ResourceMarshaler(byte[] byArray, String string) {
        super(byArray.length);
        this.serializedBinary = byArray;
        this.serializedJson = string;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealResourceMarshaler
    extends MarshalerWithSize {
        private final KeyValueMarshaler[] attributes;

        private RealResourceMarshaler(KeyValueMarshaler[] keyValueMarshalerArray) {
            super(RealResourceMarshaler.calculateSize(keyValueMarshalerArray));
            this.attributes = keyValueMarshalerArray;
        }

        @Override
        protected void writeTo(Serializer serializer) throws IOException {
            serializer.serializeRepeatedMessage(Resource.ATTRIBUTES, this.attributes);
        }

        private static int calculateSize(KeyValueMarshaler[] keyValueMarshalerArray) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Resource.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
        }
    }
}

