/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanContext;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.internal.Exemplar;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import java.io.IOException;
import java.util.List;

final class ExemplarMarshaler
extends MarshalerWithSize {
    private final long timeUnixNano;
    private final ExemplarData value;
    private final ProtoFieldInfo valueField;
    private final SpanContext spanContext;
    private final KeyValueMarshaler[] filteredAttributeMarshalers;

    static ExemplarMarshaler[] createRepeated(List<? extends ExemplarData> list) {
        int n2 = list.size();
        ExemplarMarshaler[] exemplarMarshalerArray = new ExemplarMarshaler[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            exemplarMarshalerArray[i2] = ExemplarMarshaler.create(list.get(i2));
        }
        return exemplarMarshalerArray;
    }

    private static ExemplarMarshaler create(ExemplarData exemplarData) {
        ProtoFieldInfo protoFieldInfo;
        KeyValueMarshaler[] keyValueMarshalerArray = KeyValueMarshaler.createRepeated(exemplarData.getFilteredAttributes());
        if (exemplarData instanceof LongExemplarData) {
            protoFieldInfo = Exemplar.AS_INT;
        } else {
            assert (exemplarData instanceof DoubleExemplarData);
            protoFieldInfo = Exemplar.AS_DOUBLE;
        }
        return new ExemplarMarshaler(exemplarData.getEpochNanos(), exemplarData, protoFieldInfo, exemplarData.getSpanContext(), keyValueMarshalerArray);
    }

    private ExemplarMarshaler(long l2, ExemplarData exemplarData, ProtoFieldInfo protoFieldInfo, SpanContext spanContext, KeyValueMarshaler[] keyValueMarshalerArray) {
        super(ExemplarMarshaler.calculateSize(l2, protoFieldInfo, exemplarData, spanContext, keyValueMarshalerArray));
        this.timeUnixNano = l2;
        this.value = exemplarData;
        this.valueField = protoFieldInfo;
        this.spanContext = spanContext;
        this.filteredAttributeMarshalers = keyValueMarshalerArray;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeFixed64(Exemplar.TIME_UNIX_NANO, this.timeUnixNano);
        if (this.valueField == Exemplar.AS_INT) {
            serializer.serializeFixed64Optional(this.valueField, ((LongExemplarData)this.value).getValue());
        } else {
            serializer.serializeDoubleOptional(this.valueField, ((DoubleExemplarData)this.value).getValue());
        }
        if (this.spanContext.isValid()) {
            serializer.serializeSpanId(Exemplar.SPAN_ID, this.spanContext.getSpanId());
            serializer.serializeTraceId(Exemplar.TRACE_ID, this.spanContext.getTraceId());
        }
        serializer.serializeRepeatedMessage(Exemplar.FILTERED_ATTRIBUTES, this.filteredAttributeMarshalers);
    }

    private static int calculateSize(long l2, ProtoFieldInfo protoFieldInfo, ExemplarData exemplarData, SpanContext spanContext, KeyValueMarshaler[] keyValueMarshalerArray) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeFixed64(Exemplar.TIME_UNIX_NANO, l2);
        n2 = protoFieldInfo == Exemplar.AS_INT ? (n2 += MarshalerUtil.sizeFixed64Optional(protoFieldInfo, ((LongExemplarData)exemplarData).getValue())) : (n2 += MarshalerUtil.sizeDoubleOptional(protoFieldInfo, ((DoubleExemplarData)exemplarData).getValue()));
        if (spanContext.isValid()) {
            n2 += MarshalerUtil.sizeSpanId(Exemplar.SPAN_ID, spanContext.getSpanId());
            n2 += MarshalerUtil.sizeTraceId(Exemplar.TRACE_ID, spanContext.getTraceId());
        }
        return n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Exemplar.FILTERED_ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
    }
}

