/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.ExemplarMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramBucketsMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogramDataPoint;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.ExponentialHistogramPointData;
import java.io.IOException;
import java.util.Collection;

public class ExponentialHistogramDataPointMarshaler
extends MarshalerWithSize {
    private final long startTimeUnixNano;
    private final long timeUnixNano;
    private final int scale;
    private final long count;
    private final long zeroCount;
    private final double sum;
    private final boolean hasMin;
    private final double min;
    private final boolean hasMax;
    private final double max;
    private final ExponentialHistogramBucketsMarshaler positiveBuckets;
    private final ExponentialHistogramBucketsMarshaler negativeBuckets;
    private final ExemplarMarshaler[] exemplars;
    private final KeyValueMarshaler[] attributes;

    private ExponentialHistogramDataPointMarshaler(long l2, long l3, int n2, long l4, double d2, boolean bl2, double d3, boolean bl3, double d4, long l5, ExponentialHistogramBucketsMarshaler exponentialHistogramBucketsMarshaler, ExponentialHistogramBucketsMarshaler exponentialHistogramBucketsMarshaler2, KeyValueMarshaler[] keyValueMarshalerArray, ExemplarMarshaler[] exemplarMarshalerArray) {
        super(ExponentialHistogramDataPointMarshaler.calculateSize(l2, l3, n2, l4, d2, bl2, d3, bl3, d4, l5, exponentialHistogramBucketsMarshaler, exponentialHistogramBucketsMarshaler2, exemplarMarshalerArray, keyValueMarshalerArray));
        this.startTimeUnixNano = l2;
        this.timeUnixNano = l3;
        this.scale = n2;
        this.sum = d2;
        this.hasMin = bl2;
        this.min = d3;
        this.hasMax = bl3;
        this.max = d4;
        this.count = l4;
        this.zeroCount = l5;
        this.positiveBuckets = exponentialHistogramBucketsMarshaler;
        this.negativeBuckets = exponentialHistogramBucketsMarshaler2;
        this.attributes = keyValueMarshalerArray;
        this.exemplars = exemplarMarshalerArray;
    }

    static ExponentialHistogramDataPointMarshaler create(ExponentialHistogramPointData exponentialHistogramPointData) {
        KeyValueMarshaler[] keyValueMarshalerArray = KeyValueMarshaler.createRepeated(exponentialHistogramPointData.getAttributes());
        ExemplarMarshaler[] exemplarMarshalerArray = ExemplarMarshaler.createRepeated(exponentialHistogramPointData.getExemplars());
        ExponentialHistogramBucketsMarshaler exponentialHistogramBucketsMarshaler = ExponentialHistogramBucketsMarshaler.create(exponentialHistogramPointData.getPositiveBuckets());
        ExponentialHistogramBucketsMarshaler exponentialHistogramBucketsMarshaler2 = ExponentialHistogramBucketsMarshaler.create(exponentialHistogramPointData.getNegativeBuckets());
        return new ExponentialHistogramDataPointMarshaler(exponentialHistogramPointData.getStartEpochNanos(), exponentialHistogramPointData.getEpochNanos(), exponentialHistogramPointData.getScale(), exponentialHistogramPointData.getCount(), exponentialHistogramPointData.getSum(), exponentialHistogramPointData.hasMin(), exponentialHistogramPointData.getMin(), exponentialHistogramPointData.hasMax(), exponentialHistogramPointData.getMax(), exponentialHistogramPointData.getZeroCount(), exponentialHistogramBucketsMarshaler, exponentialHistogramBucketsMarshaler2, keyValueMarshalerArray, exemplarMarshalerArray);
    }

    static ExponentialHistogramDataPointMarshaler[] createRepeated(Collection<ExponentialHistogramPointData> collection) {
        ExponentialHistogramDataPointMarshaler[] exponentialHistogramDataPointMarshalerArray = new ExponentialHistogramDataPointMarshaler[collection.size()];
        int n2 = 0;
        for (ExponentialHistogramPointData exponentialHistogramPointData : collection) {
            exponentialHistogramDataPointMarshalerArray[n2++] = ExponentialHistogramDataPointMarshaler.create(exponentialHistogramPointData);
        }
        return exponentialHistogramDataPointMarshalerArray;
    }

    @Override
    protected void writeTo(Serializer serializer) throws IOException {
        serializer.serializeFixed64(ExponentialHistogramDataPoint.START_TIME_UNIX_NANO, this.startTimeUnixNano);
        serializer.serializeFixed64(ExponentialHistogramDataPoint.TIME_UNIX_NANO, this.timeUnixNano);
        serializer.serializeFixed64(ExponentialHistogramDataPoint.COUNT, this.count);
        serializer.serializeDouble(ExponentialHistogramDataPoint.SUM, this.sum);
        if (this.hasMin) {
            serializer.serializeDoubleOptional(ExponentialHistogramDataPoint.MIN, this.min);
        }
        if (this.hasMax) {
            serializer.serializeDoubleOptional(ExponentialHistogramDataPoint.MAX, this.max);
        }
        serializer.serializeSInt32(ExponentialHistogramDataPoint.SCALE, this.scale);
        serializer.serializeFixed64(ExponentialHistogramDataPoint.ZERO_COUNT, this.zeroCount);
        serializer.serializeMessage(ExponentialHistogramDataPoint.POSITIVE, this.positiveBuckets);
        serializer.serializeMessage(ExponentialHistogramDataPoint.NEGATIVE, this.negativeBuckets);
        serializer.serializeRepeatedMessage(ExponentialHistogramDataPoint.EXEMPLARS, this.exemplars);
        serializer.serializeRepeatedMessage(ExponentialHistogramDataPoint.ATTRIBUTES, this.attributes);
    }

    private static int calculateSize(long l2, long l3, int n2, long l4, double d2, boolean bl2, double d3, boolean bl3, double d4, long l5, ExponentialHistogramBucketsMarshaler exponentialHistogramBucketsMarshaler, ExponentialHistogramBucketsMarshaler exponentialHistogramBucketsMarshaler2, ExemplarMarshaler[] exemplarMarshalerArray, KeyValueMarshaler[] keyValueMarshalerArray) {
        int n3 = 0;
        n3 += MarshalerUtil.sizeFixed64(ExponentialHistogramDataPoint.START_TIME_UNIX_NANO, l2);
        n3 += MarshalerUtil.sizeFixed64(ExponentialHistogramDataPoint.TIME_UNIX_NANO, l3);
        n3 += MarshalerUtil.sizeSInt32(ExponentialHistogramDataPoint.SCALE, n2);
        n3 += MarshalerUtil.sizeFixed64(ExponentialHistogramDataPoint.COUNT, l4);
        n3 += MarshalerUtil.sizeDouble(ExponentialHistogramDataPoint.SUM, d2);
        if (bl2) {
            n3 += MarshalerUtil.sizeDoubleOptional(ExponentialHistogramDataPoint.MIN, d3);
        }
        if (bl3) {
            n3 += MarshalerUtil.sizeDoubleOptional(ExponentialHistogramDataPoint.MAX, d4);
        }
        n3 += MarshalerUtil.sizeFixed64(ExponentialHistogramDataPoint.ZERO_COUNT, l5);
        n3 += MarshalerUtil.sizeMessage(ExponentialHistogramDataPoint.POSITIVE, exponentialHistogramBucketsMarshaler);
        n3 += MarshalerUtil.sizeMessage(ExponentialHistogramDataPoint.NEGATIVE, exponentialHistogramBucketsMarshaler2);
        n3 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ExponentialHistogramDataPoint.EXEMPLARS, (Marshaler[])exemplarMarshalerArray);
        return n3 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)ExponentialHistogramDataPoint.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
    }
}

