/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.ExemplarMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.internal.HistogramDataPoint;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal.PrimitiveLongList;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

final class HistogramDataPointMarshaler
extends MarshalerWithSize {
    private final long startTimeUnixNano;
    private final long timeUnixNano;
    private final long count;
    private final double sum;
    private final boolean hasMin;
    private final double min;
    private final boolean hasMax;
    private final double max;
    private final List<Long> bucketCounts;
    private final List<Double> explicitBounds;
    private final ExemplarMarshaler[] exemplars;
    private final KeyValueMarshaler[] attributes;

    static HistogramDataPointMarshaler[] createRepeated(Collection<HistogramPointData> collection) {
        HistogramDataPointMarshaler[] histogramDataPointMarshalerArray = new HistogramDataPointMarshaler[collection.size()];
        int n2 = 0;
        for (HistogramPointData histogramPointData : collection) {
            histogramDataPointMarshalerArray[n2++] = HistogramDataPointMarshaler.create(histogramPointData);
        }
        return histogramDataPointMarshalerArray;
    }

    static HistogramDataPointMarshaler create(HistogramPointData histogramPointData) {
        KeyValueMarshaler[] keyValueMarshalerArray = KeyValueMarshaler.createRepeated(histogramPointData.getAttributes());
        ExemplarMarshaler[] exemplarMarshalerArray = ExemplarMarshaler.createRepeated(histogramPointData.getExemplars());
        return new HistogramDataPointMarshaler(histogramPointData.getStartEpochNanos(), histogramPointData.getEpochNanos(), histogramPointData.getCount(), histogramPointData.getSum(), histogramPointData.hasMin(), histogramPointData.getMin(), histogramPointData.hasMax(), histogramPointData.getMax(), histogramPointData.getCounts(), histogramPointData.getBoundaries(), exemplarMarshalerArray, keyValueMarshalerArray);
    }

    private HistogramDataPointMarshaler(long l2, long l3, long l4, double d2, boolean bl2, double d3, boolean bl3, double d4, List<Long> list, List<Double> list2, ExemplarMarshaler[] exemplarMarshalerArray, KeyValueMarshaler[] keyValueMarshalerArray) {
        super(HistogramDataPointMarshaler.calculateSize(l2, l3, l4, d2, bl2, d3, bl3, d4, list, list2, exemplarMarshalerArray, keyValueMarshalerArray));
        this.startTimeUnixNano = l2;
        this.timeUnixNano = l3;
        this.count = l4;
        this.sum = d2;
        this.hasMin = bl2;
        this.min = d3;
        this.hasMax = bl3;
        this.max = d4;
        this.bucketCounts = list;
        this.explicitBounds = list2;
        this.exemplars = exemplarMarshalerArray;
        this.attributes = keyValueMarshalerArray;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeFixed64(HistogramDataPoint.START_TIME_UNIX_NANO, this.startTimeUnixNano);
        serializer.serializeFixed64(HistogramDataPoint.TIME_UNIX_NANO, this.timeUnixNano);
        serializer.serializeFixed64(HistogramDataPoint.COUNT, this.count);
        serializer.serializeDoubleOptional(HistogramDataPoint.SUM, this.sum);
        if (this.hasMin) {
            serializer.serializeDoubleOptional(HistogramDataPoint.MIN, this.min);
        }
        if (this.hasMax) {
            serializer.serializeDoubleOptional(HistogramDataPoint.MAX, this.max);
        }
        serializer.serializeRepeatedFixed64(HistogramDataPoint.BUCKET_COUNTS, PrimitiveLongList.toArray(this.bucketCounts));
        serializer.serializeRepeatedDouble(HistogramDataPoint.EXPLICIT_BOUNDS, this.explicitBounds);
        serializer.serializeRepeatedMessage(HistogramDataPoint.EXEMPLARS, this.exemplars);
        serializer.serializeRepeatedMessage(HistogramDataPoint.ATTRIBUTES, this.attributes);
    }

    private static int calculateSize(long l2, long l3, long l4, double d2, boolean bl2, double d3, boolean bl3, double d4, List<Long> list, List<Double> list2, ExemplarMarshaler[] exemplarMarshalerArray, KeyValueMarshaler[] keyValueMarshalerArray) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeFixed64(HistogramDataPoint.START_TIME_UNIX_NANO, l2);
        n2 += MarshalerUtil.sizeFixed64(HistogramDataPoint.TIME_UNIX_NANO, l3);
        n2 += MarshalerUtil.sizeFixed64(HistogramDataPoint.COUNT, l4);
        n2 += MarshalerUtil.sizeDoubleOptional(HistogramDataPoint.SUM, d2);
        if (bl2) {
            n2 += MarshalerUtil.sizeDoubleOptional(HistogramDataPoint.MIN, d3);
        }
        if (bl3) {
            n2 += MarshalerUtil.sizeDoubleOptional(HistogramDataPoint.MAX, d4);
        }
        n2 += MarshalerUtil.sizeRepeatedFixed64(HistogramDataPoint.BUCKET_COUNTS, list);
        n2 += MarshalerUtil.sizeRepeatedDouble(HistogramDataPoint.EXPLICIT_BOUNDS, list2);
        n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)HistogramDataPoint.EXEMPLARS, (Marshaler[])exemplarMarshalerArray);
        return n2 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)HistogramDataPoint.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
    }
}

