/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.GaugeMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.HistogramMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.NoopMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.SumMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.SummaryMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.metrics.v1.internal.Metric;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import java.io.IOException;

final class MetricMarshaler
extends MarshalerWithSize {
    private final byte[] nameUtf8;
    private final byte[] descriptionUtf8;
    private final byte[] unitUtf8;
    private final Marshaler dataMarshaler;
    private final ProtoFieldInfo dataField;

    static Marshaler create(MetricData metricData) {
        byte[] byArray = MarshalerUtil.toBytes(metricData.getName());
        byte[] byArray2 = MarshalerUtil.toBytes(metricData.getDescription());
        byte[] byArray3 = MarshalerUtil.toBytes(metricData.getUnit());
        MarshalerWithSize marshalerWithSize = null;
        ProtoFieldInfo protoFieldInfo = null;
        switch (metricData.getType()) {
            case LONG_GAUGE: {
                marshalerWithSize = GaugeMarshaler.create(metricData.getLongGaugeData());
                protoFieldInfo = Metric.GAUGE;
                break;
            }
            case DOUBLE_GAUGE: {
                marshalerWithSize = GaugeMarshaler.create(metricData.getDoubleGaugeData());
                protoFieldInfo = Metric.GAUGE;
                break;
            }
            case LONG_SUM: {
                marshalerWithSize = SumMarshaler.create(metricData.getLongSumData());
                protoFieldInfo = Metric.SUM;
                break;
            }
            case DOUBLE_SUM: {
                marshalerWithSize = SumMarshaler.create(metricData.getDoubleSumData());
                protoFieldInfo = Metric.SUM;
                break;
            }
            case SUMMARY: {
                marshalerWithSize = SummaryMarshaler.create(metricData.getSummaryData());
                protoFieldInfo = Metric.SUMMARY;
                break;
            }
            case HISTOGRAM: {
                marshalerWithSize = HistogramMarshaler.create(metricData.getHistogramData());
                protoFieldInfo = Metric.HISTOGRAM;
                break;
            }
            case EXPONENTIAL_HISTOGRAM: {
                marshalerWithSize = ExponentialHistogramMarshaler.create(metricData.getExponentialHistogramData());
                protoFieldInfo = Metric.EXPONENTIAL_HISTOGRAM;
            }
        }
        if (marshalerWithSize == null || protoFieldInfo == null) {
            return NoopMarshaler.INSTANCE;
        }
        return new MetricMarshaler(byArray, byArray2, byArray3, marshalerWithSize, protoFieldInfo);
    }

    private MetricMarshaler(byte[] byArray, byte[] byArray2, byte[] byArray3, Marshaler marshaler, ProtoFieldInfo protoFieldInfo) {
        super(MetricMarshaler.calculateSize(byArray, byArray2, byArray3, marshaler, protoFieldInfo));
        this.nameUtf8 = byArray;
        this.descriptionUtf8 = byArray2;
        this.unitUtf8 = byArray3;
        this.dataMarshaler = marshaler;
        this.dataField = protoFieldInfo;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeString(Metric.NAME, this.nameUtf8);
        serializer.serializeString(Metric.DESCRIPTION, this.descriptionUtf8);
        serializer.serializeString(Metric.UNIT, this.unitUtf8);
        serializer.serializeMessage(this.dataField, this.dataMarshaler);
    }

    private static int calculateSize(byte[] byArray, byte[] byArray2, byte[] byArray3, Marshaler marshaler, ProtoFieldInfo protoFieldInfo) {
        int n2 = 0;
        n2 += MarshalerUtil.sizeBytes(Metric.NAME, byArray);
        n2 += MarshalerUtil.sizeBytes(Metric.DESCRIPTION, byArray2);
        n2 += MarshalerUtil.sizeBytes(Metric.UNIT, byArray3);
        return n2 += MarshalerUtil.sizeMessage(protoFieldInfo, marshaler);
    }
}

