/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.trace.v1.internal.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.EventData;
import java.io.IOException;
import java.util.List;

final class SpanEventMarshaler
extends MarshalerWithSize {
    private static final SpanEventMarshaler[] EMPTY = new SpanEventMarshaler[0];
    private final long epochNanos;
    private final byte[] name;
    private final KeyValueMarshaler[] attributeMarshalers;
    private final int droppedAttributesCount;

    static SpanEventMarshaler[] createRepeated(List<EventData> list) {
        if (list.isEmpty()) {
            return EMPTY;
        }
        SpanEventMarshaler[] spanEventMarshalerArray = new SpanEventMarshaler[list.size()];
        int n2 = 0;
        for (EventData eventData : list) {
            spanEventMarshalerArray[n2++] = SpanEventMarshaler.create(eventData);
        }
        return spanEventMarshalerArray;
    }

    static SpanEventMarshaler create(EventData eventData) {
        return new SpanEventMarshaler(eventData.getEpochNanos(), MarshalerUtil.toBytes(eventData.getName()), KeyValueMarshaler.createRepeated(eventData.getAttributes()), eventData.getTotalAttributeCount() - eventData.getAttributes().size());
    }

    private SpanEventMarshaler(long l2, byte[] byArray, KeyValueMarshaler[] keyValueMarshalerArray, int n2) {
        super(SpanEventMarshaler.calculateSize(l2, byArray, keyValueMarshalerArray, n2));
        this.epochNanos = l2;
        this.name = byArray;
        this.attributeMarshalers = keyValueMarshalerArray;
        this.droppedAttributesCount = n2;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeFixed64(Span.Event.TIME_UNIX_NANO, this.epochNanos);
        serializer.serializeString(Span.Event.NAME, this.name);
        serializer.serializeRepeatedMessage(Span.Event.ATTRIBUTES, this.attributeMarshalers);
        serializer.serializeUInt32(Span.Event.DROPPED_ATTRIBUTES_COUNT, this.droppedAttributesCount);
    }

    private static int calculateSize(long l2, byte[] byArray, KeyValueMarshaler[] keyValueMarshalerArray, int n2) {
        int n3 = 0;
        n3 += MarshalerUtil.sizeFixed64(Span.Event.TIME_UNIX_NANO, l2);
        n3 += MarshalerUtil.sizeBytes(Span.Event.NAME, byArray);
        n3 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.Event.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
        return n3 += MarshalerUtil.sizeUInt32(Span.Event.DROPPED_ATTRIBUTES_COUNT, n2);
    }
}

