/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.SpanKind;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.TraceState;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.trace.propagation.internal.W3CTraceContextEncoding;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Marshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.marshal.Serializer;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces.SpanEventMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces.SpanLinkMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces.SpanStatusMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.proto.trace.v1.internal.Span;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

final class SpanMarshaler
extends MarshalerWithSize {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final String traceId;
    private final byte[] traceStateUtf8;
    private final String spanId;
    @Nullable
    private final String parentSpanId;
    private final byte[] nameUtf8;
    private final ProtoEnumInfo spanKind;
    private final long startEpochNanos;
    private final long endEpochNanos;
    private final KeyValueMarshaler[] attributeMarshalers;
    private final int droppedAttributesCount;
    private final SpanEventMarshaler[] spanEventMarshalers;
    private final int droppedEventsCount;
    private final SpanLinkMarshaler[] spanLinkMarshalers;
    private final int droppedLinksCount;
    private final SpanStatusMarshaler spanStatusMarshaler;

    static SpanMarshaler create(SpanData spanData) {
        KeyValueMarshaler[] keyValueMarshalerArray = KeyValueMarshaler.createRepeated(spanData.getAttributes());
        SpanEventMarshaler[] spanEventMarshalerArray = SpanEventMarshaler.createRepeated(spanData.getEvents());
        SpanLinkMarshaler[] spanLinkMarshalerArray = SpanLinkMarshaler.createRepeated(spanData.getLinks());
        String string = spanData.getParentSpanContext().isValid() ? spanData.getParentSpanContext().getSpanId() : null;
        TraceState traceState = spanData.getSpanContext().getTraceState();
        byte[] byArray = traceState.isEmpty() ? EMPTY_BYTES : W3CTraceContextEncoding.encodeTraceState(traceState).getBytes(StandardCharsets.UTF_8);
        return new SpanMarshaler(spanData.getSpanContext().getTraceId(), spanData.getSpanContext().getSpanId(), byArray, string, MarshalerUtil.toBytes(spanData.getName()), SpanMarshaler.toProtoSpanKind(spanData.getKind()), spanData.getStartEpochNanos(), spanData.getEndEpochNanos(), keyValueMarshalerArray, spanData.getTotalAttributeCount() - spanData.getAttributes().size(), spanEventMarshalerArray, spanData.getTotalRecordedEvents() - spanData.getEvents().size(), spanLinkMarshalerArray, spanData.getTotalRecordedLinks() - spanData.getLinks().size(), SpanStatusMarshaler.create(spanData.getStatus()));
    }

    private SpanMarshaler(String string, String string2, byte[] byArray, @Nullable String string3, byte[] byArray2, ProtoEnumInfo protoEnumInfo, long l2, long l3, KeyValueMarshaler[] keyValueMarshalerArray, int n2, SpanEventMarshaler[] spanEventMarshalerArray, int n3, SpanLinkMarshaler[] spanLinkMarshalerArray, int n4, SpanStatusMarshaler spanStatusMarshaler) {
        super(SpanMarshaler.calculateSize(string, string2, byArray, string3, byArray2, protoEnumInfo, l2, l3, keyValueMarshalerArray, n2, spanEventMarshalerArray, n3, spanLinkMarshalerArray, n4, spanStatusMarshaler));
        this.traceId = string;
        this.spanId = string2;
        this.traceStateUtf8 = byArray;
        this.parentSpanId = string3;
        this.nameUtf8 = byArray2;
        this.spanKind = protoEnumInfo;
        this.startEpochNanos = l2;
        this.endEpochNanos = l3;
        this.attributeMarshalers = keyValueMarshalerArray;
        this.droppedAttributesCount = n2;
        this.spanEventMarshalers = spanEventMarshalerArray;
        this.droppedEventsCount = n3;
        this.spanLinkMarshalers = spanLinkMarshalerArray;
        this.droppedLinksCount = n4;
        this.spanStatusMarshaler = spanStatusMarshaler;
    }

    @Override
    public void writeTo(Serializer serializer) throws IOException {
        serializer.serializeTraceId(Span.TRACE_ID, this.traceId);
        serializer.serializeSpanId(Span.SPAN_ID, this.spanId);
        serializer.serializeString(Span.TRACE_STATE, this.traceStateUtf8);
        serializer.serializeSpanId(Span.PARENT_SPAN_ID, this.parentSpanId);
        serializer.serializeString(Span.NAME, this.nameUtf8);
        serializer.serializeEnum(Span.KIND, this.spanKind);
        serializer.serializeFixed64(Span.START_TIME_UNIX_NANO, this.startEpochNanos);
        serializer.serializeFixed64(Span.END_TIME_UNIX_NANO, this.endEpochNanos);
        serializer.serializeRepeatedMessage(Span.ATTRIBUTES, this.attributeMarshalers);
        serializer.serializeUInt32(Span.DROPPED_ATTRIBUTES_COUNT, this.droppedAttributesCount);
        serializer.serializeRepeatedMessage(Span.EVENTS, this.spanEventMarshalers);
        serializer.serializeUInt32(Span.DROPPED_EVENTS_COUNT, this.droppedEventsCount);
        serializer.serializeRepeatedMessage(Span.LINKS, this.spanLinkMarshalers);
        serializer.serializeUInt32(Span.DROPPED_LINKS_COUNT, this.droppedLinksCount);
        serializer.serializeMessage(Span.STATUS, this.spanStatusMarshaler);
    }

    private static int calculateSize(String string, String string2, byte[] byArray, @Nullable String string3, byte[] byArray2, ProtoEnumInfo protoEnumInfo, long l2, long l3, KeyValueMarshaler[] keyValueMarshalerArray, int n2, SpanEventMarshaler[] spanEventMarshalerArray, int n3, SpanLinkMarshaler[] spanLinkMarshalerArray, int n4, SpanStatusMarshaler spanStatusMarshaler) {
        int n5 = 0;
        n5 += MarshalerUtil.sizeTraceId(Span.TRACE_ID, string);
        n5 += MarshalerUtil.sizeSpanId(Span.SPAN_ID, string2);
        n5 += MarshalerUtil.sizeBytes(Span.TRACE_STATE, byArray);
        n5 += MarshalerUtil.sizeSpanId(Span.PARENT_SPAN_ID, string3);
        n5 += MarshalerUtil.sizeBytes(Span.NAME, byArray2);
        n5 += MarshalerUtil.sizeEnum(Span.KIND, protoEnumInfo);
        n5 += MarshalerUtil.sizeFixed64(Span.START_TIME_UNIX_NANO, l2);
        n5 += MarshalerUtil.sizeFixed64(Span.END_TIME_UNIX_NANO, l3);
        n5 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.ATTRIBUTES, (Marshaler[])keyValueMarshalerArray);
        n5 += MarshalerUtil.sizeUInt32(Span.DROPPED_ATTRIBUTES_COUNT, n2);
        n5 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.EVENTS, (Marshaler[])spanEventMarshalerArray);
        n5 += MarshalerUtil.sizeUInt32(Span.DROPPED_EVENTS_COUNT, n3);
        n5 += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Span.LINKS, (Marshaler[])spanLinkMarshalerArray);
        n5 += MarshalerUtil.sizeUInt32(Span.DROPPED_LINKS_COUNT, n4);
        return n5 += MarshalerUtil.sizeMessage(Span.STATUS, spanStatusMarshaler);
    }

    static ProtoEnumInfo toProtoSpanKind(SpanKind spanKind) {
        switch (spanKind) {
            case INTERNAL: {
                return Span.SpanKind.SPAN_KIND_INTERNAL;
            }
            case SERVER: {
                return Span.SpanKind.SPAN_KIND_SERVER;
            }
            case CLIENT: {
                return Span.SpanKind.SPAN_KIND_CLIENT;
            }
            case PRODUCER: {
                return Span.SpanKind.SPAN_KIND_PRODUCER;
            }
            case CONSUMER: {
                return Span.SpanKind.SPAN_KIND_CONSUMER;
            }
        }
        return Span.SpanKind.SPAN_KIND_UNSPECIFIED;
    }
}

