/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpHttpMetricExporter
implements MetricExporter {
    private final HttpExporterBuilder<MetricsRequestMarshaler> builder;
    private final HttpExporter<MetricsRequestMarshaler> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;

    OtlpHttpMetricExporter(HttpExporterBuilder<MetricsRequestMarshaler> httpExporterBuilder, HttpExporter<MetricsRequestMarshaler> httpExporter, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector) {
        this.builder = httpExporterBuilder;
        this.delegate = httpExporter;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
    }

    public static OtlpHttpMetricExporter getDefault() {
        return OtlpHttpMetricExporter.builder().build();
    }

    public static OtlpHttpMetricExporterBuilder builder() {
        return new OtlpHttpMetricExporterBuilder();
    }

    public OtlpHttpMetricExporterBuilder toBuilder() {
        return new OtlpHttpMetricExporterBuilder(this.builder.copy());
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> collection) {
        MetricsRequestMarshaler metricsRequestMarshaler = MetricsRequestMarshaler.create(collection);
        return this.delegate.export(metricsRequestMarshaler, collection.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpHttpMetricExporter{" + this.builder.toString(false) + "}";
    }
}

