/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.metrics;

import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.Aggregation;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.InstrumentType;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.data.MetricData;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcMetricExporter
implements MetricExporter {
    private final GrpcExporterBuilder<MetricsRequestMarshaler> builder;
    private final GrpcExporter<MetricsRequestMarshaler> delegate;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;

    public static OtlpGrpcMetricExporter getDefault() {
        return OtlpGrpcMetricExporter.builder().build();
    }

    public static OtlpGrpcMetricExporterBuilder builder() {
        return new OtlpGrpcMetricExporterBuilder();
    }

    OtlpGrpcMetricExporter(GrpcExporterBuilder<MetricsRequestMarshaler> grpcExporterBuilder, GrpcExporter<MetricsRequestMarshaler> grpcExporter, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector) {
        this.builder = grpcExporterBuilder;
        this.delegate = grpcExporter;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
    }

    public OtlpGrpcMetricExporterBuilder toBuilder() {
        return new OtlpGrpcMetricExporterBuilder(this.builder.copy());
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> collection) {
        MetricsRequestMarshaler metricsRequestMarshaler = MetricsRequestMarshaler.create(collection);
        return this.delegate.export(metricsRequestMarshaler, collection.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        return "OtlpGrpcMetricExporter{" + this.builder.toString(false) + "}";
    }
}

