/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.trace;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Utils;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.metrics.MeterProvider;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.internal.otlp.traces.TraceRequestMarshaler;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.trace.MarshalerTraceServiceGrpc;
import com.contrastsecurity.thirdparty.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.export.RetryPolicy;
import io.grpc.ManagedChannel;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

public final class OtlpGrpcSpanExporterBuilder {
    static final String GRPC_SERVICE_NAME = "com.contrastsecurity.thirdparty.opentelemetry.proto.collector.trace.v1.TraceService";
    static final String GRPC_ENDPOINT_PATH = "/opentelemetry.proto.collector.trace.v1.TraceService/Export";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:4317";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:4317");
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    final GrpcExporterBuilder<TraceRequestMarshaler> delegate;

    OtlpGrpcSpanExporterBuilder(GrpcExporterBuilder<TraceRequestMarshaler> grpcExporterBuilder) {
        this.delegate = grpcExporterBuilder;
        OtlpUserAgent.addUserAgentHeader(grpcExporterBuilder::addHeader);
    }

    OtlpGrpcSpanExporterBuilder() {
        this(new GrpcExporterBuilder<TraceRequestMarshaler>("otlp", "span", 10L, DEFAULT_ENDPOINT, () -> MarshalerTraceServiceGrpc::newFutureStub, GRPC_ENDPOINT_PATH));
    }

    @Deprecated
    public OtlpGrpcSpanExporterBuilder setChannel(ManagedChannel managedChannel) {
        this.delegate.setChannel(managedChannel);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(long l2, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "unit");
        Utils.checkArgument(l2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(l2, timeUnit);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTimeout(Duration duration) {
        Objects.requireNonNull(duration, "timeout");
        this.delegate.setTimeout(duration);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setEndpoint(String string) {
        Objects.requireNonNull(string, "endpoint");
        this.delegate.setEndpoint(string);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setCompression(String string) {
        Objects.requireNonNull(string, "compressionMethod");
        Utils.checkArgument(string.equals("gzip") || string.equals("none"), "Unsupported compression method. Supported compression methods include: gzip, none.");
        this.delegate.setCompression(string);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setTrustedCertificates(byte[] byArray) {
        this.delegate.setTrustManagerFromCerts(byArray);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setClientTls(byte[] byArray, byte[] byArray2) {
        this.delegate.setKeyManagerFromCerts(byArray, byArray2);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setSslContext(SSLContext sSLContext, X509TrustManager x509TrustManager) {
        this.delegate.setSslContext(sSLContext, x509TrustManager);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder addHeader(String string, String string2) {
        this.delegate.addHeader(string, string2);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setRetryPolicy(RetryPolicy retryPolicy) {
        Objects.requireNonNull(retryPolicy, "retryPolicy");
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpGrpcSpanExporterBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.delegate.setMeterProvider(meterProvider);
        return this;
    }

    public OtlpGrpcSpanExporter build() {
        return new OtlpGrpcSpanExporter(this.delegate, this.delegate.build());
    }
}

