/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.autoconfigure.spi.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.ConfigUtil;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DefaultConfigProperties
implements ConfigProperties {
    private final Map<String, String> config;

    public static DefaultConfigProperties create(Map<String, String> map) {
        return new DefaultConfigProperties(System.getProperties(), System.getenv(), map);
    }

    public static DefaultConfigProperties createForTest(Map<String, String> map) {
        return new DefaultConfigProperties(map, Collections.emptyMap(), Collections.emptyMap());
    }

    private DefaultConfigProperties(Map<?, ?> map, Map<String, String> map2, Map<String, String> map3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        map3.forEach((string, string2) -> hashMap.put(ConfigUtil.normalizePropertyKey(string), (String)string2));
        map2.forEach((string, string2) -> hashMap.put(ConfigUtil.normalizeEnvironmentVariableKey(string), (String)string2));
        map.forEach((object, object2) -> hashMap.put(ConfigUtil.normalizePropertyKey(object.toString()), object2.toString()));
        this.config = hashMap;
    }

    private DefaultConfigProperties(DefaultConfigProperties defaultConfigProperties, Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(defaultConfigProperties.config);
        map.forEach((string, string2) -> hashMap.put(ConfigUtil.normalizePropertyKey(string), (String)string2));
        this.config = hashMap;
    }

    @Override
    @Nullable
    public String getString(String string) {
        return this.config.get(ConfigUtil.normalizePropertyKey(string));
    }

    @Override
    @Nullable
    public Boolean getBoolean(String string) {
        String string2 = this.config.get(ConfigUtil.normalizePropertyKey(string));
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(string2);
    }

    @Override
    @Nullable
    public Integer getInt(String string) {
        String string2 = this.config.get(ConfigUtil.normalizePropertyKey(string));
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw DefaultConfigProperties.newInvalidPropertyException(string, string2, "integer");
        }
    }

    @Override
    @Nullable
    public Long getLong(String string) {
        String string2 = this.config.get(ConfigUtil.normalizePropertyKey(string));
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw DefaultConfigProperties.newInvalidPropertyException(string, string2, "long");
        }
    }

    @Override
    @Nullable
    public Double getDouble(String string) {
        String string2 = this.config.get(ConfigUtil.normalizePropertyKey(string));
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw DefaultConfigProperties.newInvalidPropertyException(string, string2, "double");
        }
    }

    @Override
    @Nullable
    public Duration getDuration(String string) {
        String string2 = this.config.get(ConfigUtil.normalizePropertyKey(string));
        if (string2 == null || string2.isEmpty()) {
            return null;
        }
        String string3 = DefaultConfigProperties.getUnitString(string2);
        String string4 = string2.substring(0, string2.length() - string3.length());
        try {
            long l2 = Long.parseLong(string4.trim());
            TimeUnit timeUnit = DefaultConfigProperties.getDurationUnit(string3.trim());
            return Duration.ofMillis(TimeUnit.MILLISECONDS.convert(l2, timeUnit));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Invalid duration property " + string + "=" + string2 + ". Expected number, found: " + string4, numberFormatException);
        }
        catch (ConfigurationException configurationException) {
            throw new ConfigurationException("Invalid duration property " + string + "=" + string2 + ". " + configurationException.getMessage());
        }
    }

    @Override
    public List<String> getList(String string) {
        String string2 = this.config.get(ConfigUtil.normalizePropertyKey(string));
        if (string2 == null) {
            return Collections.emptyList();
        }
        return DefaultConfigProperties.filterBlanksAndNulls(string2.split(","));
    }

    public static Set<String> getSet(ConfigProperties configProperties, String string) {
        List<String> list = configProperties.getList(ConfigUtil.normalizePropertyKey(string));
        HashSet<String> hashSet = new HashSet<String>(list);
        if (hashSet.size() != list.size()) {
            String string2 = list.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]"));
            throw new ConfigurationException(string + " contains duplicates: " + string2);
        }
        return hashSet;
    }

    @Override
    public Map<String, String> getMap(String string3) {
        return this.getList(ConfigUtil.normalizePropertyKey(string3)).stream().map(string -> DefaultConfigProperties.filterBlanksAndNulls(string.split("=", 2))).map(list -> {
            if (list.size() != 2) {
                throw new ConfigurationException("Invalid map property: " + string3 + "=" + this.config.get(string3));
            }
            return new AbstractMap.SimpleImmutableEntry<String, String>((String)list.get(0), (String)list.get(1));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (string, string2) -> string2, LinkedHashMap::new));
    }

    public DefaultConfigProperties withOverrides(Map<String, String> map) {
        return new DefaultConfigProperties(this, map);
    }

    private static ConfigurationException newInvalidPropertyException(String string, String string2, String string3) {
        throw new ConfigurationException("Invalid value for property " + string + "=" + string2 + ". Must be a " + string3 + ".");
    }

    private static List<String> filterBlanksAndNulls(String[] stringArray) {
        return Arrays.stream(stringArray).map(String::trim).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    private static TimeUnit getDurationUnit(String string) {
        switch (string) {
            case "": 
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "d": {
                return TimeUnit.DAYS;
            }
        }
        throw new ConfigurationException("Invalid duration string, found: " + string);
    }

    private static String getUnitString(String string) {
        char c2;
        int n2;
        for (n2 = string.length() - 1; n2 >= 0 && !Character.isDigit(c2 = string.charAt(n2)); --n2) {
        }
        return string.substring(n2 + 1);
    }
}

