/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class AttributeUtil {
    private AttributeUtil() {
    }

    public static Attributes applyAttributesLimit(Attributes attributes, int n2, int n3) {
        if (attributes.isEmpty() || attributes.size() <= n2) {
            if (n3 == Integer.MAX_VALUE) {
                return attributes;
            }
            boolean bl2 = AttributeUtil.allMatch(attributes.asMap().values(), object -> AttributeUtil.isValidLength(object, n3));
            if (bl2) {
                return attributes;
            }
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        int n4 = 0;
        for (Map.Entry<AttributeKey<?>, Object> entry : attributes.asMap().entrySet()) {
            if (n4 >= n2) break;
            attributesBuilder.put(entry.getKey(), AttributeUtil.applyAttributeLengthLimit(entry.getValue(), n3));
            ++n4;
        }
        return attributesBuilder.build();
    }

    private static boolean isValidLength(Object object2, int n2) {
        if (object2 instanceof List) {
            return AttributeUtil.allMatch((List)object2, object -> AttributeUtil.isValidLength(object, n2));
        }
        if (object2 instanceof String) {
            return ((String)object2).length() < n2;
        }
        return true;
    }

    private static <T> boolean allMatch(Iterable<T> iterable, Predicate<T> predicate) {
        for (T t2 : iterable) {
            if (predicate.test(t2)) continue;
            return false;
        }
        return true;
    }

    public static Object applyAttributeLengthLimit(Object object, int n2) {
        if (n2 == Integer.MAX_VALUE) {
            return object;
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (Object e2 : list) {
                arrayList.add(AttributeUtil.applyAttributeLengthLimit(e2, n2));
            }
            return arrayList;
        }
        if (object instanceof String) {
            String string = (String)object;
            return string.length() < n2 ? object : string.substring(0, n2);
        }
        return object;
    }
}

