/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.internal;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.common.Attributes;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ComponentRegistry<V> {
    private final Map<String, V> componentByName = new ConcurrentHashMap<String, V>();
    private final Map<String, Map<String, V>> componentByNameAndVersion = new ConcurrentHashMap<String, Map<String, V>>();
    private final Map<String, Map<String, V>> componentByNameAndSchema = new ConcurrentHashMap<String, Map<String, V>>();
    private final Map<String, Map<String, Map<String, V>>> componentByNameVersionAndSchema = new ConcurrentHashMap<String, Map<String, Map<String, V>>>();
    private final Object lock = new Object();
    private final Set<V> allComponents = Collections.newSetFromMap(new IdentityHashMap());
    private final Function<InstrumentationScopeInfo, V> factory;

    public ComponentRegistry(Function<InstrumentationScopeInfo, V> function) {
        this.factory = function;
    }

    public V get(String string4, @Nullable String string5, @Nullable String string6, Attributes attributes) {
        if (string5 != null && string6 != null) {
            Map map = this.componentByNameVersionAndSchema.computeIfAbsent(string4, string -> new ConcurrentHashMap());
            Map map2 = map.computeIfAbsent(string5, string -> new ConcurrentHashMap());
            return (V)map2.computeIfAbsent(string6, string3 -> this.buildComponent(InstrumentationScopeInfo.builder(string4).setVersion(string5).setSchemaUrl((String)string3).setAttributes(attributes).build()));
        }
        if (string5 != null) {
            Map map = this.componentByNameAndVersion.computeIfAbsent(string4, string -> new ConcurrentHashMap());
            return (V)map.computeIfAbsent(string5, string2 -> this.buildComponent(InstrumentationScopeInfo.builder(string4).setVersion((String)string2).setAttributes(attributes).build()));
        }
        if (string6 != null) {
            Map map = this.componentByNameAndSchema.computeIfAbsent(string4, string -> new ConcurrentHashMap());
            return (V)map.computeIfAbsent(string6, string2 -> this.buildComponent(InstrumentationScopeInfo.builder(string4).setSchemaUrl((String)string2).setAttributes(attributes).build()));
        }
        return (V)this.componentByName.computeIfAbsent(string4, string -> this.buildComponent(InstrumentationScopeInfo.builder(string).setAttributes(attributes).build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V buildComponent(InstrumentationScopeInfo instrumentationScopeInfo) {
        V v2 = this.factory.apply(instrumentationScopeInfo);
        Object object = this.lock;
        synchronized (object) {
            this.allComponents.add(v2);
        }
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> getComponents() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableCollection(new ArrayList<V>(this.allComponents));
        }
    }
}

