/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs;

import com.contrastsecurity.thirdparty.io.opentelemetry.api.internal.Utils;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.LogLimits;

public final class LogLimitsBuilder {
    private static final int DEFAULT_LOG_MAX_NUM_ATTRIBUTES = 128;
    private static final int DEFAULT_LOG_MAX_ATTRIBUTE_LENGTH = Integer.MAX_VALUE;
    private int maxNumAttributes = 128;
    private int maxAttributeValueLength = Integer.MAX_VALUE;

    LogLimitsBuilder() {
    }

    public LogLimitsBuilder setMaxNumberOfAttributes(int n2) {
        Utils.checkArgument(n2 > 0, "maxNumberOfAttributes must be greater than 0");
        this.maxNumAttributes = n2;
        return this;
    }

    public LogLimitsBuilder setMaxAttributeValueLength(int n2) {
        Utils.checkArgument(n2 > -1, "maxAttributeValueLength must be non-negative");
        this.maxAttributeValueLength = n2;
        return this;
    }

    public LogLimits build() {
        return LogLimits.create(this.maxNumAttributes, this.maxAttributeValueLength);
    }
}

