/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs;

import com.contrastsecurity.thirdparty.io.opentelemetry.context.Context;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.MultiLogRecordProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.NoopLogRecordProcessor;
import com.contrastsecurity.thirdparty.io.opentelemetry.sdk.logs.ReadWriteLogRecord;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface LogRecordProcessor
extends Closeable {
    public static LogRecordProcessor composite(LogRecordProcessor ... logRecordProcessorArray) {
        return LogRecordProcessor.composite(Arrays.asList(logRecordProcessorArray));
    }

    public static LogRecordProcessor composite(Iterable<LogRecordProcessor> iterable) {
        ArrayList<LogRecordProcessor> arrayList = new ArrayList<LogRecordProcessor>();
        for (LogRecordProcessor logRecordProcessor : iterable) {
            arrayList.add(logRecordProcessor);
        }
        if (arrayList.isEmpty()) {
            return NoopLogRecordProcessor.getInstance();
        }
        if (arrayList.size() == 1) {
            return (LogRecordProcessor)arrayList.get(0);
        }
        return MultiLogRecordProcessor.create(arrayList);
    }

    public void onEmit(Context var1, ReadWriteLogRecord var2);

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

